/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalVersionMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperClassEntity;

final class VersionMapping
extends ConvertibleMapping
implements ExternalVersionMapping {
    static final String CONVERT = "convert";
    static final String MUTABLE = "mutable";
    static final String TEMPORAL = "temporal";
    static final String VERSION = "version";

    @Override
    public String getNoSqlField() {
        return null;
    }

    @Override
    public void setNoSqlField(String field) {
    }

    VersionMapping(MappedSuperClassEntity parent, int index) {
        super(parent, index);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("access");
        names.add(MUTABLE);
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn() {
        return new EntityColumn(this);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add(TEMPORAL);
        names.add(CONVERT);
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("property");
        names.add("access-methods");
        return names;
    }

    @Override
    public EntityColumn getColumn() {
        if (this.hasChild("column")) {
            return this.buildColumn();
        }
        return null;
    }

    @Override
    public String getConvert() {
        return this.getChildTextNode(CONVERT);
    }

    @Override
    protected String getElementName() {
        return VERSION;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode(TEMPORAL, TemporalType.class);
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute(MUTABLE);
    }

    @Override
    public void setAttributeType(String attributeType) {
        this.setAttribute("attribute-type", attributeType);
    }

    @Override
    public void setColumn(String columnName) {
        EntityColumn column = this.getColumn();
        if (column == null && columnName != null) {
            column = this.buildColumn();
            column.addSelf();
        } else if (column != null && columnName == null) {
            column.removeSelf();
        }
        if (columnName != null) {
            column.setName(columnName);
        }
    }

    @Override
    public void setConvert(String convert) {
        this.updateChildTextNode(CONVERT, convert);
    }

    @Override
    public void setMutable(Boolean mutable) {
        this.setAttribute(MUTABLE, mutable);
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode(TEMPORAL, (Enum<?>)type);
    }
}

