/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyListIterator;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.event.ListAddEvent;
import org.eclipse.persistence.tools.utility.model.event.ListChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.ListClearEvent;
import org.eclipse.persistence.tools.utility.model.event.ListMoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListRemoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListReplaceEvent;
import org.eclipse.persistence.tools.utility.model.value.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;
import org.eclipse.persistence.tools.utility.model.value.ListValueModelWrapper;
import org.eclipse.persistence.tools.utility.reference.SimpleIntReference;

public abstract class ItemAspectListValueModelAdapter<E>
extends ListValueModelWrapper<E>
implements ListValueModel<E> {
    protected final IdentityHashMap<E, SimpleIntReference> counters = new IdentityHashMap();

    protected ItemAspectListValueModelAdapter(ListValueModel<? extends E> listHolder) {
        super(listHolder);
    }

    protected ItemAspectListValueModelAdapter(CollectionValueModel<? extends E> collectionHolder) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder));
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this.listModel.listIterator());
    }

    @Override
    public E get(int index) {
        return this.listModel.get(index);
    }

    @Override
    public int size() {
        return this.listModel.size();
    }

    @Override
    public Object[] toArray() {
        return this.listModel.toArray();
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.engageAllItems();
    }

    protected void engageAllItems() {
        this.engageItems(this.listModel);
    }

    protected void engageItems(Iterable<? extends E> items) {
        for (E item : items) {
            this.engageItem(item);
        }
    }

    protected void engageItem(E item) {
        SimpleIntReference counter = this.counters.get(item);
        if (counter == null) {
            counter = new SimpleIntReference();
            this.counters.put(item, counter);
            this.engageItem_((Model)item);
        }
        counter.increment();
    }

    protected abstract void engageItem_(Model var1);

    @Override
    protected void disengageModel() {
        this.disengageAllItems();
        super.disengageModel();
    }

    protected void disengageAllItems() {
        this.disengageItems(this.listModel);
    }

    protected void disengageItems(Iterable<? extends E> items) {
        for (E item : items) {
            this.disengageItem(item);
        }
    }

    protected void disengageItem(E item) {
        SimpleIntReference counter = this.counters.get(item);
        if (counter == null) {
            throw new IllegalStateException("missing counter: " + item);
        }
        if (counter.decrement() == 0) {
            this.counters.remove(item);
            this.disengageItem_((Model)item);
        }
    }

    protected abstract void disengageItem_(Model var1);

    @Override
    public void toString(StringBuilder sb) {
        StringBuilderTools.append(sb, this);
    }

    @Override
    protected void itemsAdded(ListAddEvent event) {
        this.fireItemsAdded(event.clone(this, "list values"));
        this.engageItems(this.getItems(event));
    }

    @Override
    protected void itemsRemoved(ListRemoveEvent event) {
        this.disengageItems(this.getItems(event));
        this.fireItemsRemoved(event.clone(this, "list values"));
    }

    @Override
    protected void itemsReplaced(ListReplaceEvent event) {
        this.disengageItems(this.getOldItems(event));
        this.fireItemsReplaced(event.clone(this, "list values"));
        this.engageItems(this.getNewItems(event));
    }

    @Override
    protected void itemsMoved(ListMoveEvent event) {
        this.fireItemsMoved(event.clone(this, "list values"));
    }

    @Override
    protected void listCleared(ListClearEvent event) {
        ArrayList<E> keys = new ArrayList<E>(this.counters.keySet());
        this.disengageItems(keys);
        this.counters.clear();
        this.fireListCleared("list values");
    }

    @Override
    protected void listChanged(ListChangeEvent event) {
        ArrayList<E> keys = new ArrayList<E>(this.counters.keySet());
        this.disengageItems(keys);
        this.counters.clear();
        this.fireListChanged(event.clone(this));
        this.engageAllItems();
    }

    protected void itemAspectChanged(EventObject event) {
        this.fireListChanged("list values", ListTools.list(this.listModel, this.listModel.size()));
    }
}

