/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import java.util.Arrays;
import java.util.EventListener;
import java.util.EventObject;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;
import org.eclipse.persistence.tools.utility.model.ChangeSupport;
import org.eclipse.persistence.tools.utility.model.Model;
import org.eclipse.persistence.tools.utility.model.SingleAspectChangeSupport;
import org.eclipse.persistence.tools.utility.model.event.ListReplaceEvent;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.value.CollectionListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.CollectionValueModel;
import org.eclipse.persistence.tools.utility.model.value.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.utility.model.value.ListValueModel;

public class ItemPropertyListValueModelAdapter<E>
extends ItemAspectListValueModelAdapter<E> {
    protected final String[] propertyNames;
    protected final PropertyChangeListener itemPropertyListener;

    public ItemPropertyListValueModelAdapter(ListValueModel<E> listHolder, String ... propertyNames) {
        super(listHolder);
        if (propertyNames == null) {
            throw new NullPointerException();
        }
        this.propertyNames = propertyNames;
        this.itemPropertyListener = this.buildItemPropertyListener();
    }

    public ItemPropertyListValueModelAdapter(CollectionValueModel<E> collectionHolder, String ... propertyNames) {
        this(new CollectionListValueModelAdapter<E>(collectionHolder), propertyNames);
    }

    protected PropertyChangeListener buildItemPropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChanged(PropertyChangeEvent event) {
                ItemPropertyListValueModelAdapter.this.itemAspectChanged(event);
            }

            public String toString() {
                return "item property listener: " + Arrays.asList(ItemPropertyListValueModelAdapter.this.propertyNames);
            }
        };
    }

    @Override
    protected void engageItem_(Model item) {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            item.addPropertyChangeListener(propertyName, this.itemPropertyListener);
            ++n2;
        }
    }

    @Override
    protected void disengageItem_(Model item) {
        String[] stringArray = this.propertyNames;
        int n = this.propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            item.removePropertyChangeListener(propertyName, this.itemPropertyListener);
            ++n2;
        }
    }

    @Override
    protected void itemAspectChanged(EventObject event) {
        Object item = event.getSource();
        this.getChangeSupport().fireItemsReplaced(new ListReplaceEvent((Model)this, "list values", IterableTools.indexOf(this.listModel, item), item, item));
    }

    @Override
    protected ChangeSupport buildChangeSupport() {
        return new LocalChangeSupport(this, ListChangeListener.class, "list values");
    }

    class LocalChangeSupport
    extends SingleAspectChangeSupport {
        private static final long serialVersionUID = 1L;

        LocalChangeSupport(Model source, Class<? extends EventListener> validListenerClass, String validAspectName) {
            super(source, validListenerClass, validAspectName);
        }

        @Override
        public boolean fireItemsReplaced(ListReplaceEvent event) {
            this.check(LIST_CHANGE_LISTENER_CLASS, event.getListName());
            if (event.getItemsSize() != 0) {
                this.fireItemsReplaced_(event);
                return true;
            }
            return false;
        }
    }
}

