/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.model.platformsmodel;

import org.eclipse.persistence.tools.db.model.platformsmodel.CorruptXMLException;
import org.eclipse.persistence.tools.db.model.platformsmodel.JDBCTypeRepository;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.node.AbstractNode;
import org.w3c.dom.Node;

public final class JDBCType
extends AbstractNode {
    private String name;
    public static final String NAME_PROPERTY = "name";
    private int code;
    public static final String CODE_PROPERTY = "code";

    JDBCType(JDBCTypeRepository repository, Node node) throws CorruptXMLException {
        super((org.eclipse.persistence.tools.utility.node.Node)repository);
        this.read(node);
    }

    JDBCType(JDBCTypeRepository repository, String name, int code) {
        super((org.eclipse.persistence.tools.utility.node.Node)repository);
        this.name = name;
        this.code = code;
    }

    private JDBCTypeRepository getJDBCTypeRepository() {
        return (JDBCTypeRepository)this.getParent();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.getJDBCTypeRepository().checkJDBCTypeName(name);
        String old = this.name;
        this.name = name;
        this.firePropertyChanged(NAME_PROPERTY, old, name);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.getJDBCTypeRepository().checkJDBCTypeCode(code);
        int old = this.code;
        this.code = code;
        this.firePropertyChanged(CODE_PROPERTY, old, code);
    }

    private void read(Node node) throws CorruptXMLException {
        if (node == null) {
            throw new CorruptXMLException("missing node");
        }
        this.name = XMLTools.getChildTextContent((Node)node, (String)NAME_PROPERTY, null);
        if (this.name == null || this.name.length() == 0) {
            throw new CorruptXMLException("name is required");
        }
        this.code = XMLTools.childIntContent((Node)node, (String)CODE_PROPERTY, (int)-7777);
    }

    void write(Node node) {
        XMLTools.addSimpleTextNode((Node)node, (String)NAME_PROPERTY, (String)this.name);
        XMLTools.addSimpleTextNode((Node)node, (String)CODE_PROPERTY, (int)this.code, (int)-7777);
    }

    public String displayString() {
        return this.name;
    }

    public void toString(StringBuffer sb) {
        sb.append(this.name);
    }
}

