/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.model;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.tools.utility.tests.model.listener.UtilityModelListenerTests;
import org.eclipse.persistence.tools.utility.tests.model.value.UtilityModelValueTests;

public class CommonUtilityModelTests {

	public static Test suite() {
		TestSuite suite = new TestSuite(CommonUtilityModelTests.class.getPackage().getName());

		suite.addTest(UtilityModelListenerTests.suite());
		suite.addTest(UtilityModelValueTests.suite());

		suite.addTestSuite(ChangeSupportTests.class);
		suite.addTestSuite(NewEventTests.class);
		suite.addTestSuite(SingleAspectChangeSupportTests.class);

		return suite;
	}

	private CommonUtilityModelTests() {
		super();
		throw new UnsupportedOperationException();
	}
}