/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.annotations.Direction;

/**
 * This interface and inherited behavior describe the configurable properties defined for a stored
 * procedure parameter in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.StoredProcedureQuery
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalStoredProcedureParameter extends ExternalForm {

	/**
	 * Returns the direction type for this parameter.
	 */
	Direction getDirection();

	/**
	 * Returns the position of this parameter within its parent procedure.
	 */
	int getIndex();

	/**
	 * Returns the jdbc type of this parameter.
	 */
	Integer getJdbcType();

	/**
	 * Returns the jdbc type name for this parameter.
	 */
	String getJdbcTypeName();

	/**
	 * Returns the name of this parameter.
	 */
	String getName();

	/**
	 * Returns the query parameter for this parameter.
	 */
	String getQueryParameter();

	/**
	 * Returns the type name for this parameter.
	 */
	String getType();

	/**
	 * Sets the direction type for this parameter.
	 */
	void setDirection(Direction directionType);

	/**
	 * Sets the jdbc type for this parameter.
	 */
	void setJdbcType(Integer jdbcType);

	/**
	 * Sets the jdbc type name for this parameter.
	 */
	void setJdbcTypeName(String jdbcTypeName);

	/**
	 * Sets the name of this parameter.
	 */
	void setName(String name);

	/**
	 * Sets the query parameter name for this parameter.
	 */
	void setQueryParameter(String queryParameterName);

	/**
	 * Sets the type name for this parameter.
	 */
	void setType(String typeName);
}