/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.iterable.ListIterable;


/**
 * This interface represents the transformation mapping defined by the EclipseLink JPA spec that are
 * available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalTransformationMapping extends ExternalMappedMapping {

	/**
	 * Adds the read transformer.
	 */
	ExternalTransformer addReadTransformer();

	/**
	 * Adds a write transformer.
	 */
	ExternalWriteTransformer addWriteTransformer(int index);

	/**
	 * Returns the read transformer.
	 */
	ExternalTransformer getReadTransformer();

	/**
	 * Returns the write transformer at the index.
	 */
	ExternalWriteTransformer getWriteTransformer(int index);

	/**
	 * Returns whether the mapping is mutable.
	 */
	Boolean isMutable();

	/**
	 * Removes the read transformer.
	 */
	void removeReadTransformer();

	/**
	 * Removes the write transformer at the index.
	 */
	void removeWriteTransformer(int index);

	/**
	 * Sets whether the mapping is mutable or not.
	 */
	void setIsMutable(Boolean mutable);

	/**
	 * Returns all the write transformers.
	 */
	ListIterable<ExternalWriteTransformer> writeTransformers();

	/**
	 * Returns the number of write transformers.
	 */
	int writeTransformersSize();
}