/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalStructConverter;

/**
 * The external form of a struct converter, which is a child of an entity.
 *
 * @see BasicMapMapping
 * @see ConvertibleMapping
 * @see ElementCollectionMapping
 * @see EmbeddableEntity
 * @see ORMConfiguration
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class StructConverter extends ClassConverter
                            implements ExternalStructConverter {

	/**
	 * The attribute name used to store and retrieve the converter property.
	 */
	static final String CONVERTER = "converter";

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String STRUCT_CONVERTER = "struct-converter";

	/**
	 * Creates a new <code>StructConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	StructConverter(BasicMapMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>StructConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	StructConverter(ConvertibleMapping parent, int index) {
		super(parent, index);
	}

	/**
	 * Creates a new <code>StructConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	StructConverter(ElementCollectionMapping parent) {
		super(parent);
	}

	/**
	 * Creates a new <code>StructConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	StructConverter(EmbeddableEntity parent, int index) {
		super(parent, index);
	}

	/**
	 * Creates a new <code>StructConverter</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the element within the list of children with the same type owned
	 * by the parent
	 */
	StructConverter(ORMConfiguration parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = super.buildAttributeNamesOrder();
		names.add(NAME);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	String getConverterClassElementName() {
		return CONVERTER;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return STRUCT_CONVERTER;
	}
}