/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.io;

import java.io.Writer;
import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * This is a writer that does nothing.
 * Everything is thrown into the "bit bucket".
 * Performance should be pretty good....
 */
public final class NullWriter
	extends Writer
{
	// singleton
	private static Writer INSTANCE = new NullWriter();

	/**
	 * Return the singleton.
	 */
	public static synchronized Writer instance() {
		return INSTANCE;
	}

	/**
	 * Ensure non-instantiability.
	 */
	private NullWriter() {
		super();
	}

	@Override
	public void write(char[] cbuf, int off, int len) {
		// do nothing
	}

	@Override
	public void flush() {
		// do nothing
	}

	@Override
	public void close() {
		// do nothing
	}

	@Override
	public void write(char[] cbuf) {
		// do nothing
	}

	@Override
	public void write(int c) {
		// do nothing
	}

	@Override
	public void write(String str, int off, int len) {
		// do nothing
	}

	@Override
	public void write(String str) {
		// do nothing
	}

	@Override
	public String toString() {
		return ObjectTools.singletonToString(this);
	}
}