/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;

/**
 * A <code>ReverseIterator</code> wraps another {@link Iterator} and returns
 * its elements in the reverse order in which the wrapped {@link Iterator}
 * returns the elements.
 *
 * @param <E> the type of elements returned by the iterator
 */
public class ReverseIterator<E>
	implements Iterator<E>
{
	/**
	 * The elements in this iterator are already reversed.
	 */
	private final Iterator<E> iterator;


	/**
	 * Construct a reverse iterator for the specified iterator.
	 */
	public ReverseIterator(Iterator<E> iterator) {
		this((ArrayList<E>) ListTools.reverse(ListTools.list(iterator)));
	}

	/**
	 * Construct a reverse iterator for the specified iterator.
	 */
	public ReverseIterator(Iterator<E> iterator, int size) {
		this((ArrayList<E>) ListTools.reverse(ListTools.list(iterator, size)));
	}

	/**
	 * Construct a reverse iterator for the specified iterable.
	 */
	public ReverseIterator(Iterable<E> iterable) {
		this((ArrayList<E>) ListTools.reverse(ListTools.list(iterable)));
	}

	/**
	 * Construct a reverse iterator for the specified iterable.
	 */
	public ReverseIterator(Iterable<E> iterable, int size) {
		this((ArrayList<E>) ListTools.reverse(ListTools.list(iterable, size)));
	}

	private ReverseIterator(ArrayList<E> reverseList) {
		super();
		this.iterator = reverseList.iterator();
	}

	@Override
	public boolean hasNext() {
		return this.iterator.hasNext();
	}

	@Override
	public E next() {
		return this.iterator.next();
	}

	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this);
	}
}