/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.transformer;

import org.eclipse.persistence.tools.utility.ObjectTools;

/**
 * Convenience transformer that returns <code>null</code> for every
 * transformation.
 *
 * @param <T1> the type of the object passed to the transformer
 * @param <T2> the type of the object returned by the transformer
 *
 * @see AbstractTransformer
 */
public class TransformerAdapter<T1, T2>
	implements Transformer<T1, T2>
{
	@Override
	public T2 transform(T1 o) {
		return null;
	}

	@Override
	public String toString() {
		return ObjectTools.toString(this);
	}
}