/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.persistence.tools.workbench.framework.context.PreferencesContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.GroupBox;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingTools;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.EisPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.ServerPlatformManager;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.NullServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatformAdapter;
import org.eclipse.persistence.tools.workbench.uitools.ComponentEnabler;
import org.eclipse.persistence.tools.workbench.uitools.app.BufferedPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimpleCollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SimplePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.adapters.PreferencePropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.ClassTools;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.string.BidiStringConverter;

final class PlatformPreferencesPage
extends AbstractPanel {
    private String previousServerClassName;
    private JComboBox serverPlatformChooser;
    private BufferedPropertyValueModel serverPlatformHolder;
    private JComponent serverPlatformWidgets;
    private JCheckBox useServerPlatformCheckBox;

    PlatformPreferencesPage(PreferencesContext context) {
        super((LayoutManager)new BorderLayout(), context);
        this.intializeLayout();
        this.addHelpTopicId(this, "preferences.sessions.platform");
    }

    private void buildChooserComponentEnabler(JRadioButton radioButton, JComponent widgets) {
        final SimplePropertyValueModel booleanHolder = new SimplePropertyValueModel(radioButton.isSelected());
        radioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JRadioButton radioButton = (JRadioButton)e.getSource();
                Boolean value = radioButton.isSelected();
                booleanHolder.setValue(value);
            }
        });
        new ComponentEnabler((ValueModel)booleanHolder, Collections.singleton(widgets));
    }

    private ListDataListener buildComboBoxListDataListener() {
        return new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() == -1 && e.getIndex1() == -1) {
                    String serverClassName = (String)PlatformPreferencesPage.this.serverPlatformChooser.getSelectedItem();
                    PlatformPreferencesPage.this.updateServerPlatformWidgets(serverClassName);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }
        };
    }

    private PropertyValueModel buildDatabaseTypeHolder() {
        return new BufferedPropertyValueModel(this.buildDatabaseTypeHolderImp(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildDatabaseTypeHolderImp() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "data source type", (Object)"relational");
        adapter.setConverter(new BidiStringConverter(){

            public Object convertToObject(String value) {
                return this.convertToString(value);
            }

            public String convertToString(Object value) {
                if ("relational".equals(value)) {
                    return "relational";
                }
                if ("eis".equals(value)) {
                    return "eis";
                }
                if ("xml".equals(value)) {
                    return "xml";
                }
                return value != null ? value.toString() : null;
            }
        });
        return adapter;
    }

    private JComponent buildDefaultDatabaseSourceTypePane() {
        GridBagConstraints constraints = new GridBagConstraints();
        PropertyValueModel databaseTypeHolder = this.buildDatabaseTypeHolder();
        int offset = SwingTools.checkBoxIconWidth();
        JPanel container = new JPanel(new GridBagLayout());
        container.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PREFERENCES_DEFAULT_DATA_SOURCE_TYPE_GROUP_BOX"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        JRadioButton relationalRadioButton = this.buildRadioButton("RELATIONAL_RADIO_BUTTON", this.buildRelationalButtonModelAdapter(databaseTypeHolder));
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, 0, 0, 0);
        container.add((Component)relationalRadioButton, constraints);
        JComponent relationalChooserWidgets = this.buildRelationalPlatformWidgets();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, offset, 0, 0);
        container.add((Component)relationalChooserWidgets, constraints);
        this.buildChooserComponentEnabler(relationalRadioButton, relationalChooserWidgets);
        JRadioButton eisRadioButton = this.buildRadioButton("EIS_RADIO_BUTTON", this.buildEisButtonModelAdapter(databaseTypeHolder));
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)eisRadioButton, constraints);
        JComponent eisChooserWidgets = this.buildEisPlatformWidgets();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 21;
        constraints.insets = new Insets(0, offset, 0, 0);
        container.add((Component)eisChooserWidgets, constraints);
        this.buildChooserComponentEnabler(eisRadioButton, eisChooserWidgets);
        JRadioButton xmlRadioButton = this.buildRadioButton("XML_RADIO_BUTTON", this.buildXmlButtonModelAdapter(databaseTypeHolder));
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.anchor = 21;
        constraints.insets = new Insets(5, 0, 0, 0);
        container.add((Component)xmlRadioButton, constraints);
        return container;
    }

    private JPanel buildDefaultServerPlatformPane() {
        this.useServerPlatformCheckBox = this.buildCheckBox("USE_SERVER_PLATFORM_CHECK_BOX", new DefaultButtonModel());
        this.useServerPlatformCheckBox.addActionListener(this.buildServerPlatformAction());
        this.serverPlatformChooser = new JComboBox(this.buildServerPlatformComboBoxModel());
        this.serverPlatformChooser.setRenderer(this.buildServerPlatformRenderer());
        this.serverPlatformChooser.getModel().addListDataListener(this.buildComboBoxListDataListener());
        this.serverPlatformWidgets = this.buildLabeledComponent("PREFERENCES_DEFAULT_SERVER_PLATFORM_COMBO_BOX", this.serverPlatformChooser);
        this.serverPlatformWidgets.setBorder(BorderFactory.createEmptyBorder(0, SwingTools.checkBoxIconWidth(), 0, 0));
        String serverClassName = (String)this.serverPlatformChooser.getSelectedItem();
        this.updateServerPlatformWidgets(serverClassName);
        return new GroupBox(this.useServerPlatformCheckBox, this.serverPlatformWidgets);
    }

    private ButtonModel buildEisButtonModelAdapter(PropertyValueModel databaseTypeHolder) {
        return new RadioButtonModelAdapter(databaseTypeHolder, "eis");
    }

    private ListCellRenderer buildEisNameRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object cellValue) {
                if (((String)cellValue).equals("AQPlatform")) {
                    return "Oracle AQ";
                }
                if (((String)cellValue).equals("JMSPlatform")) {
                    return "JMS";
                }
                if (((String)cellValue).equals("MQPlatform")) {
                    return "IBM MQSeries";
                }
                return "XML File";
            }
        };
    }

    private ComboBoxModel buildEisPlatformCollectionHolder() {
        SortedSet platforms = CollectionTools.sortedSet((Iterator)EisPlatformManager.instance().platformShortNames());
        return new ComboBoxModelAdapter(new SimpleCollectionValueModel(platforms), this.buildEisPlatformHolder());
    }

    private PropertyValueModel buildEisPlatformHolder() {
        return new BufferedPropertyValueModel(this.buildEisPlatformHolderImp(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildEisPlatformHolderImp() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "platform.eis", (Object)"AQPlatform");
        adapter.setConverter(BidiStringConverter.DEFAULT_INSTANCE);
        return adapter;
    }

    private JComponent buildEisPlatformWidgets() {
        JComboBox eisPlatformChooser = new JComboBox(this.buildEisPlatformCollectionHolder());
        eisPlatformChooser.setRenderer(this.buildEisNameRenderer());
        return this.buildLabeledComponent("EIS_PLATFORM_LABEL", eisPlatformChooser);
    }

    private ButtonModel buildRelationalButtonModelAdapter(PropertyValueModel databaseTypeHolder) {
        return new RadioButtonModelAdapter(databaseTypeHolder, "relational");
    }

    private PropertyValueModel buildRelationalPlatformHolder() {
        return new BufferedPropertyValueModel(this.buildRelationalPlatformHolderImp(), this.getPreferencesContext().getBufferTrigger());
    }

    private PropertyValueModel buildRelationalPlatformHolderImp() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "platform.database", (Object)DatabasePlatformRepository.getDefault().platformNamed("Oracle11"));
        adapter.setConverter(new BidiStringConverter(){

            public Object convertToObject(String value) {
                if (value == null) {
                    return null;
                }
                return DatabasePlatformRepository.getDefault().platformNamed(value);
            }

            public String convertToString(Object value) {
                if (value == null) {
                    return null;
                }
                DatabasePlatform platform = (DatabasePlatform)value;
                return platform.getName();
            }
        });
        return adapter;
    }

    private JComponent buildRelationalPlatformWidgets() {
        PropertyValueModel databasePlatformHolder = this.buildRelationalPlatformHolder();
        JComboBox databasePlatformComboBox = PlatformComponentFactory.buildPlatformChooser(databasePlatformHolder);
        return this.buildLabeledComponent("DATABASE_PLATFORM_LABEL", databasePlatformComboBox);
    }

    private ActionListener buildServerPlatformAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String serverClassName;
                boolean checked = ((JCheckBox)e.getSource()).isSelected();
                if (checked) {
                    PlatformPreferencesPage.this.previousServerClassName = (String)PlatformPreferencesPage.this.serverPlatformHolder.getValue();
                    serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
                    serverClassName = ClassTools.shortNameForClassNamed((String)serverClassName);
                } else {
                    if (PlatformPreferencesPage.this.previousServerClassName == null) {
                        PlatformPreferencesPage.this.previousServerClassName = "WebLogic_10_Platform";
                    }
                    serverClassName = PlatformPreferencesPage.this.previousServerClassName;
                }
                PlatformPreferencesPage.this.serverPlatformHolder.setValue(serverClassName);
            }
        };
    }

    private CollectionValueModel buildServerPlatformCollectionHolder() {
        return new SimpleCollectionValueModel(this.buildServerPlatformNames());
    }

    private ComboBoxModel buildServerPlatformComboBoxModel() {
        return new ComboBoxModelAdapter(this.buildServerPlatformCollectionHolder(), this.buildServerPlatformSelectionHolder());
    }

    private Collection buildServerPlatformNames() {
        SortedSet servers = CollectionTools.sortedSet((Iterator)ServerPlatformManager.instance().platformShortNames());
        String serverClassName = NullServerPlatformAdapter.instance().getServerClassName();
        servers.remove(ClassTools.shortNameForClassNamed((String)serverClassName));
        return servers;
    }

    private ListCellRenderer buildServerPlatformRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                if (value == null) {
                    return "";
                }
                return PlatformPreferencesPage.this.resourceRepository().getString((String)value);
            }
        };
    }

    private PropertyValueModel buildServerPlatformSelectionHolder() {
        if (this.serverPlatformHolder == null) {
            this.serverPlatformHolder = new BufferedPropertyValueModel(this.buildServerPlatformSelectionHolderImp(), this.getPreferencesContext().getBufferTrigger());
        }
        return this.serverPlatformHolder;
    }

    private PropertyValueModel buildServerPlatformSelectionHolderImp() {
        PreferencePropertyValueModel adapter = new PreferencePropertyValueModel(this.preferences(), "platform.server");
        adapter.setConverter(BidiStringConverter.DEFAULT_INSTANCE);
        return adapter;
    }

    private ButtonModel buildXmlButtonModelAdapter(PropertyValueModel databaseTypeHolder) {
        return new RadioButtonModelAdapter(databaseTypeHolder, "xml");
    }

    private void intializeLayout() {
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel container = new JPanel(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(container);
        scrollPane.setBorder(null);
        scrollPane.setViewportBorder(null);
        this.add((Component)scrollPane, "Center");
        JPanel defaultServerPlatformPane = this.buildDefaultServerPlatformPane();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 10;
        constraints.insets = new Insets(5, 5, 0, 5);
        container.add((Component)defaultServerPlatformPane, constraints);
        JComponent defaultDataSourceTypePane = this.buildDefaultDatabaseSourceTypePane();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 19;
        constraints.insets = new Insets(5, 5, 5, 5);
        container.add((Component)defaultDataSourceTypePane, constraints);
    }

    private void updateServerPlatformWidgets(String serverClassName) {
        boolean selected;
        boolean bl = selected = serverClassName != null;
        if (selected) {
            ServerPlatformAdapter noServerPlatform = NullServerPlatformAdapter.instance();
            String noServerPlatformClassName = ClassTools.shortNameForClassNamed((String)noServerPlatform.getServerClassName());
            selected = !serverClassName.equals(noServerPlatformClassName);
        }
        this.useServerPlatformCheckBox.setSelected(selected);
        this.serverPlatformWidgets.setEnabled(selected);
    }
}

