/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Image;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;

final class ComboCellRenderer
implements ListCellRenderer,
UIResource {
    final ListCellRenderer cellRenderer;
    final CellRendererAdapter cellRendererAdapter;
    private final Component prototypeRenderer;

    ComboCellRenderer(ListCellRenderer cellRenderer, CellRendererAdapter cellRendererAdapter, Component prototypeRenderer) {
        this.cellRenderer = cellRenderer;
        this.prototypeRenderer = prototypeRenderer;
        this.cellRendererAdapter = cellRendererAdapter;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean cellHasFocus) {
        if (value == this.prototypeRenderer) {
            return this.prototypeRenderer;
        }
        JLabel renderer = (JLabel)this.cellRenderer.getListCellRendererComponent(list, null, index, selected, cellHasFocus);
        renderer.setEnabled(list.isEnabled());
        this.updateRenderer(renderer, value);
        if (selected && !list.hasFocus() && list.isFocusable()) {
            renderer.setForeground(list.getForeground());
            renderer.setBackground(UIManager.getColor("Panel.background"));
        }
        if (!list.isEnabled() && renderer.getIcon() != null && renderer.getDisabledIcon() == null && renderer.getIcon() instanceof ImageIcon) {
            ImageIcon icon = (ImageIcon)renderer.getIcon();
            Image image = GrayFilter.createDisabledImage(icon.getImage());
            renderer.setIcon(new ImageIcon(image));
        }
        return renderer;
    }

    private void updateRenderer(JLabel renderer, Object value) {
        renderer.setText(this.cellRendererAdapter.buildText(value));
        renderer.setIcon(this.cellRendererAdapter.buildIcon(value));
        renderer.setToolTipText(this.cellRendererAdapter.buildToolTipText(value));
        renderer.getAccessibleContext().setAccessibleName(this.cellRendererAdapter.buildAccessibleName(value));
    }
}

