/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.Collection;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Car;
import org.eclipse.persistence.testing.models.aggregate.Transport;

public class QueryKeyInAggregateInheritanceTest
extends TestCase {
    protected Collection<Transport> results;

    public QueryKeyInAggregateInheritanceTest() {
        this.setDescription("Conforming query on a QueryKey defined on an aggregate object with an inheritance hierarchy");
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Car example = new Car();
        example.setMake("Audi");
        example.setModel("TT");
        example.setColour("Azure");
        example.setCapacity(2);
        Transport transport = new Transport();
        transport.setVehicle(example);
        uow.registerObject((Object)transport);
        ReadAllQuery query = new ReadAllQuery(Transport.class);
        ExpressionBuilder builder = query.getExpressionBuilder();
        Expression expression = builder.get("vehicle").get("colour").equal((Object)"Azure");
        query.setSelectionCriteria(expression);
        query.conformResultsInUnitOfWork();
        this.results = (Collection)uow.executeQuery((DatabaseQuery)query);
    }

    public void verify() {
        if (this.results == null || this.results.isEmpty()) {
            this.throwError("No results were returned");
        } else if (this.results.size() != 1) {
            this.throwError("Incorrect results size: " + this.results);
        }
    }

    public void reset() {
        this.results = null;
    }
}

