/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.feature;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmploymentPeriod;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;

public class EmployeeProjectForIntegrityChecker
extends Project {
    protected DatabaseSession session;

    public EmployeeProjectForIntegrityChecker() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildAddressDescriptor();
        this.buildEmployeeDescriptor();
        this.buildEmploymentPeriodDescriptor();
        this.buildLargeProjectDescriptor();
        this.buildPhoneNumberDescriptor();
        this.buildProjectDescriptor();
        this.buildSmallProjectDescriptor();
    }

    protected void applyLOGIN() {
    }

    protected void applyPROJECT() {
        this.setName("Employee");
    }

    protected void buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("ADDRESS");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("ADDRESS.ADDRESS_ID");
        descriptor.setIdentityMapClass(CacheIdentityMap.class);
        descriptor.setSequenceNumberName("ADDRESS_SEQ");
        descriptor.setSequenceNumberFieldName("ADDRESS_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("city");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("ADDRESS.CITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("country");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("ADDRESS.COUNTRY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("id");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("postalCode");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("ADDRESS.P_CODE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        DirectToFieldMapping directtofieldmapping4 = new DirectToFieldMapping();
        directtofieldmapping4.setAttributeName("province");
        directtofieldmapping4.setIsReadOnly(false);
        directtofieldmapping4.setFieldName("ADDRESS.PROVINCE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping4);
        DirectToFieldMapping directtofieldmapping5 = new DirectToFieldMapping();
        directtofieldmapping5.setAttributeName("street");
        directtofieldmapping5.setIsReadOnly(false);
        directtofieldmapping5.setFieldName("ADDRESS.STREET");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping5);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("EMPLOYEE");
        vector.addElement("SALARY");
        descriptor.setTableNames(vector);
        descriptor.setIdentityMapClass(NoIdentityMap.class);
        descriptor.setSequenceNumberFieldName("EMP_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.useVersionLocking("VERSION");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        AggregateObjectMapping aggregateobjectmapping = new AggregateObjectMapping();
        aggregateobjectmapping.setAttributeName("perio");
        aggregateobjectmapping.setIsReadOnly(false);
        aggregateobjectmapping.setReferenceClass(EmploymentPeriod.class);
        aggregateobjectmapping.setIsNullAllowed(true);
        descriptor.addMapping((DatabaseMapping)aggregateobjectmapping);
        DirectCollectionMapping directcollectionmapping = new DirectCollectionMapping();
        directcollectionmapping.setAttributeName("responsibilitiesList");
        directcollectionmapping.setIsReadOnly(false);
        directcollectionmapping.setUsesIndirection(false);
        directcollectionmapping.setIsPrivateOwned(true);
        directcollectionmapping.setDirectFieldName("RESPONS.DESCRIP");
        directcollectionmapping.addReferenceKeyFieldName("RESPONS.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)directcollectionmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("EMPLOYEE.F_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("EMPLOYEE.L_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("salary");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("SALARY.SALARY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("projects");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("PROJ_EMP");
        manytomanymapping.addSourceRelationKeyFieldName("PROJ_EMP.EMP_ID", "EMPLOYEE.EMP_ID");
        manytomanymapping.addTargetRelationKeyFieldName("PROJ_EMP.PROJ_ID", "PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        DirectToFieldMapping objecttypemapping = new DirectToFieldMapping();
        ObjectTypeConverter objecttypeconverter = new ObjectTypeConverter();
        objecttypemapping.setConverter((Converter)objecttypeconverter);
        objecttypemapping.setAttributeName("gender");
        objecttypemapping.setIsReadOnly(false);
        objecttypemapping.setFieldName("EMPLOYEE.GENDER");
        objecttypeconverter.addConversionValue((Object)"F", (Object)"Female");
        objecttypeconverter.addConversionValue((Object)"M", (Object)"Male");
        descriptor.addMapping((DatabaseMapping)objecttypemapping);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("managedEmployees");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setIsPrivateOwned(false);
        onetomanymapping.addTargetForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToManyMapping onetomanymapping1 = new OneToManyMapping();
        onetomanymapping1.setAttributeName("phoneNumbers");
        onetomanymapping1.setIsReadOnly(false);
        onetomanymapping1.setUsesIndirection(true);
        onetomanymapping1.setReferenceClass(PhoneNumber.class);
        onetomanymapping1.setIsPrivateOwned(true);
        onetomanymapping1.addTargetForeignKeyFieldName("PHONE.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetomanymapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("address");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("EMPLOYEE.ADDR_ID", "ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        OneToOneMapping onetoonemapping1 = new OneToOneMapping();
        onetoonemapping1.setAttributeName("manager");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(true);
        onetoonemapping1.setReferenceClass(Employee.class);
        onetoonemapping1.setIsPrivateOwned(false);
        onetoonemapping1.addForeignKeyFieldName("EMPLOYEE.MANAGER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping1);
        TransformationMapping transformationmapping = new TransformationMapping();
        transformationmapping.setAttributeName("normalHours");
        transformationmapping.setIsReadOnly(false);
        transformationmapping.setUsesIndirection(true);
        transformationmapping.addFieldTransformation("EMPLOYEE.END_TIME", "getEndTime");
        transformationmapping.addFieldTransformation("EMPLOYEE.START_TIME", "getStartTime");
        descriptor.addMapping((DatabaseMapping)transformationmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmploymentPeriodDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmploymentPeriod.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("EMPLOYEE");
        descriptor.setTableNames(vector);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.descriptorIsAggregate();
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("endDate");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("EMPLOYEE.END_DATE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("startDate");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("EMPLOYEE.START_DATE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildLargeProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(LargeProject.class);
        descriptor.getInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LPROJECT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LPROJECT.PROJ_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("budget");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("LPROJECT.BUDGET");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("milestoneVersion");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("LPROJECT.MILESTONE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPhoneNumberDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(PhoneNumber.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("PHONE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PHONE.EMP_ID");
        descriptor.addPrimaryKeyFieldName("PHONE.TYPE");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("areaCode");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("PHONE.AREA_CODE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("number");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("PHONE.P_NUMBER");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("type");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("PHONE.TYPE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("owner");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("PHONE.EMP_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        EmployeeSystem.modifyPhoneDescriptor((ClassDescriptor)descriptor);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("PROJECT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("PROJECT.PROJ_ID");
        descriptor.setSequenceNumberName("PROJ_SEQ");
        descriptor.useVersionLocking("VERSION");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setSequenceNumberFieldName("PROJ_ID");
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("PROJ_TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(LargeProject.class, (Object)"L");
        descriptor.getInheritancePolicy().addClassIndicator(SmallProject.class, (Object)"S");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("PROJECT.DESCRIP");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("PROJECT.PROJ_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("name");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("PROJECT.PROJ_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("teamLeader");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(true);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("PROJECT.LEADER_ID", "EMPLOYEE.EMP_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildSmallProjectDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SmallProject.class);
        descriptor.getInheritancePolicy().setParentClass(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

