/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpql;

import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.tests.jpql.JPQLTestCase;

public class CustomQueryStringTranlateValidationTest
extends JPQLTestCase {
    @Override
    public void test() throws Exception {
        String[][] EJBQLTestString = new String[][]{{"SQL1", "SELECT type 'Category',CHAR_LENGTH('#231 O''connor Street')", "SELECT type 'Category',CHAR_LENGTH('#231 O''connor Street')"}, {"SQL2", "BEGIN SProc_Insert_PHolders(#ssn, '#occupation', #sex); END;", "BEGIN SProc_Insert_PHolders(?, '#occupation', ?); END;"}, {"SQL3", "SELECT employee e WHERE e.id=?1 and e.address='#231 O''connor Street' and e.phone=?3", "SELECT employee e WHERE e.id=? and e.address='#231 O''connor Street' and e.phone=?"}, {"SQL4", "BEGIN SProc_Insert_PHolders(#ssn, ?1,'#occupation', ?2); END;", "BEGIN SProc_Insert_PHolders(?, ?1,'#occupation', ?2); END;"}, {"SQL5", "SELECT employee e WHERE e.id='?1' and e.address='#231 O''connor Street' and e.phone='?3'", "SELECT employee e WHERE e.id='?1' and e.address='#231 O''connor Street' and e.phone='?3'"}, {"SQL6", "SELECT employee e WHERE e.id='#1' and e.address='#2'", "SELECT employee e WHERE e.id='#1' and e.address='#2'"}, {"SQL7", "SELECT employee e WHERE e.id='#1 #2'", "SELECT employee e WHERE e.id='#1 #2'"}};
        this.verifyCustomQuery(EJBQLTestString);
    }

    private void verifyCustomQuery(String[][] testDatas) throws Exception {
        ReadAllQuery query = new ReadAllQuery();
        query.setShouldBindAllParameters(false);
        for (String[] testData : testDatas) {
            String sqlID = testData[0];
            String sqlString = testData[1];
            String expectedResult = testData[2];
            query.setSQLString(sqlString);
            query.getCall().translateCustomQuery();
            String translatedString = query.getCall().getQueryString();
            if (translatedString.equals(expectedResult)) continue;
            throw new Exception("DataSourceCall.translateCustomQuery() translated SQL[" + sqlID + "] into incorrect result [" + translatedString + "].");
        }
    }
}

