/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.tests.unitofwork.Weather;

public class RegisterNewObjectInIdentityMapNoSeqTest
extends AutoVerifyTestCase {
    public String sequenceNumberName;
    public DatabaseField sequenceNumberField;
    boolean keepSequencing;
    boolean shouldAlwaysOverrideExistingValue;
    IdValidation idValidation;
    boolean zeroFailed;
    boolean negativeFailed;
    boolean zeroOverridden;
    boolean negativeOverridden;
    IdValidation idValidationOriginal;
    boolean shouldAlwaysOverrideExistingValueOriginal;

    public RegisterNewObjectInIdentityMapNoSeqTest(IdValidation idValidation, boolean keepSequencing, boolean shouldAlwaysOverrideExistingValue) {
        if (idValidation != IdValidation.NULL && idValidation != IdValidation.ZERO && idValidation != IdValidation.NEGATIVE) {
            throw new TestProblemException(idValidation + " is not supported.");
        }
        this.idValidation = idValidation;
        this.keepSequencing = keepSequencing;
        if (keepSequencing) {
            this.shouldAlwaysOverrideExistingValue = shouldAlwaysOverrideExistingValue;
        }
        this.setDescription("This test verifies the the UOW cache when registering a new object with a primitive primary key");
        this.setName(this.getName() + this.getNameSuffix());
    }

    String getNameSuffix() {
        return " " + this.idValidation + (this.keepSequencing ? " Sequencing" + (this.shouldAlwaysOverrideExistingValue ? " always overrides" : "") : "");
    }

    public void reset() {
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Weather.class);
        descriptor.setIdValidation(this.idValidationOriginal);
        if (this.keepSequencing) {
            if (descriptor.getSequence() != null) {
                descriptor.getSequence().setShouldAlwaysOverrideExistingValue(this.shouldAlwaysOverrideExistingValueOriginal);
            }
        } else {
            descriptor.setSequenceNumberField(this.sequenceNumberField);
            descriptor.setSequenceNumberName(this.sequenceNumberName);
        }
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void setup() {
        this.zeroFailed = false;
        this.negativeFailed = false;
        this.zeroOverridden = false;
        this.negativeOverridden = false;
        this.getAbstractSession().beginTransaction();
        ClassDescriptor descriptor = this.getSession().getClassDescriptor(Weather.class);
        this.idValidationOriginal = descriptor.getIdValidation();
        descriptor.setIdValidation(this.idValidation);
        if (this.keepSequencing) {
            if (descriptor.getSequence() == null) {
                throw new TestWarningException("Cannot run test with descriptor.getSequence() == null");
            }
            if (!this.shouldAlwaysOverrideExistingValue && descriptor.getSequence().shouldAcquireValueAfterInsert()) {
                throw new TestProblemException("Cannot run test with keepSequencing==true and alwayOverrideExistingValueOriginal==false with Identity sequence: it should always override");
            }
            this.shouldAlwaysOverrideExistingValueOriginal = descriptor.getSequence().shouldAlwaysOverrideExistingValue();
            descriptor.getSequence().setShouldAlwaysOverrideExistingValue(this.shouldAlwaysOverrideExistingValue);
        } else {
            this.sequenceNumberField = descriptor.getSequenceNumberField();
            descriptor.setSequenceNumberField(null);
            this.sequenceNumberName = descriptor.getSequenceNumberName();
            descriptor.setSequenceNumberName(null);
        }
    }

    public void test() {
        Session session = this.getSession();
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.setShouldNewObjectsBeCached(true);
        Weather weather = new Weather();
        weather.setStormPattern("Something really bad");
        weather.id = 0L;
        ReadObjectQuery query = new ReadObjectQuery((Object)weather);
        query.checkCacheOnly();
        Weather weatherClone = (Weather)uow.registerObject((Object)weather);
        weather = (Weather)uow.executeQuery((DatabaseQuery)query);
        this.zeroFailed = weather == null;
        Weather weatherNeg = new Weather();
        weatherNeg.setStormPattern("Something really bad below zero");
        weatherNeg.id = -1L;
        ReadObjectQuery queryNeg = new ReadObjectQuery((Object)weatherNeg);
        queryNeg.checkCacheOnly();
        Weather weatherNegClone = (Weather)uow.registerObject((Object)weatherNeg);
        weatherNeg = (Weather)uow.executeQuery((DatabaseQuery)queryNeg);
        boolean bl = this.negativeFailed = weatherNeg == null;
        if (this.keepSequencing) {
            uow.assignSequenceNumbers();
            this.zeroOverridden = weatherClone.id != 0L;
            this.negativeOverridden = weatherNegClone.id != -1L;
        }
    }

    public void verify() {
        String errorMsg = "";
        boolean zeroFailedExpected = false;
        boolean negativeFailedExpected = false;
        boolean zeroOverriddenExpected = this.shouldAlwaysOverrideExistingValue;
        boolean negativeOverriddenExpected = this.shouldAlwaysOverrideExistingValue;
        if (this.idValidation != IdValidation.NULL) {
            if (this.idValidation == IdValidation.ZERO) {
                zeroFailedExpected = true;
                negativeFailedExpected = false;
                if (this.keepSequencing) {
                    zeroOverriddenExpected = true;
                    negativeOverriddenExpected = this.shouldAlwaysOverrideExistingValue;
                }
            } else if (this.idValidation == IdValidation.NEGATIVE) {
                zeroFailedExpected = true;
                negativeFailedExpected = true;
                if (this.keepSequencing) {
                    zeroOverriddenExpected = true;
                    negativeOverriddenExpected = true;
                }
            }
        }
        if (this.zeroFailed != zeroFailedExpected) {
            errorMsg = errorMsg + " zeroFailed = " + this.zeroFailed + ";";
        }
        if (this.negativeFailed != negativeFailedExpected) {
            errorMsg = errorMsg + " negativeFailed = " + this.negativeFailed + ";";
        }
        if (this.keepSequencing) {
            if (this.zeroOverridden != zeroOverriddenExpected) {
                errorMsg = errorMsg + " zeroOverridden = " + this.zeroOverridden + ";";
            }
            if (this.negativeOverridden != negativeOverriddenExpected) {
                errorMsg = errorMsg + " negativeOverridden = " + this.negativeOverridden + ";";
            }
        }
        if (errorMsg.length() > 0) {
            errorMsg = this.getNameSuffix() + ": Unexpected results: " + errorMsg;
            throw new TestErrorException(errorMsg);
        }
    }
}

