/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.advanced;

import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.LockTimeoutException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Department;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Equipment;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EquipmentCode;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.GoldBuyer;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.LargeProject;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Project;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.SmallProject;

public class AdvancedJPAJunitTest
extends JUnitTestCase {
    private static int empId;
    private static int penelopeId;
    private static int deptId;
    private static int buyerId;
    private static long visa;
    private static long amex;
    private static long diners;
    private static long mastercard;
    private static String newResponsibility;

    public AdvancedJPAJunitTest() {
    }

    public AdvancedJPAJunitTest(String name) {
        super(name);
    }

    public void setUp() {
        super.setUp();
        AdvancedJPAJunitTest.clearCache((String)"fieldaccess");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("AdvancedJPAJunitTest (fieldaccess)");
        suite.addTest((Test)new AdvancedJPAJunitTest("testSetup"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testJoinFetchAnnotation"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyEmployeeCustomizerSettings"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyEmployeeManagerMappings"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUpdateEmployee"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyUpdatedEmployee"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testCreateNewBuyer"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testVerifyNewBuyer"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testBuyerOptimisticLocking"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testGiveFredAnObjectTypeConverterChange"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUpdatePenelopesPhoneNumberStatus"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testRemoveJillWithPrivateOwnedPhoneNumbers"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testCreateNewEquipment"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testAddNewEquipmentToDepartment"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testRemoveDepartmentWithPrivateOwnedEquipment"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testUpdateReadOnlyEquipmentCode"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQuery"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryInOut"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testNamedStoredProcedureQueryWithRawData"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testTransientConstructorSetFields"));
        suite.addTest((Test)new AdvancedJPAJunitTest("testPessimisticLockingNamedQuery"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession((String)"fieldaccess");
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        ClassDescriptor descriptor = session.getDescriptor(EquipmentCode.class);
        boolean shouldBeReadOnly = descriptor.shouldBeReadOnly();
        descriptor.setShouldBeReadOnly(false);
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        descriptor.setShouldBeReadOnly(shouldBeReadOnly);
        AdvancedJPAJunitTest.clearCache((String)"fieldaccess");
    }

    public void testTransientConstructorSetFields() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        Project project = new Project();
        LargeProject lproject = new LargeProject();
        SmallProject sproject = new SmallProject();
        project.setName("TCSetFieldsProject");
        lproject.setName("TCSetFieldsLProject");
        sproject.setName("TCSetFieldsSProject");
        this.beginTransaction(em);
        project = (Project)em.merge((Object)project);
        lproject = (LargeProject)em.merge((Object)lproject);
        sproject = (SmallProject)em.merge((Object)sproject);
        AdvancedJPAJunitTest.assertTrue((String)"Project's default constructor wasn't used to create merged entity", (project.getFieldOnlySetThroughConstructor() == 1 ? 1 : 0) != 0);
        AdvancedJPAJunitTest.assertTrue((String)"LargeProject's default constructor wasn't used to create merged entity", (lproject.getFieldOnlySetThroughConstructor() == 2 ? 1 : 0) != 0);
        AdvancedJPAJunitTest.assertTrue((String)"Project's default constructor wasn't used to create merged SmallProject", (sproject.getFieldOnlySetThroughConstructor() == 1 ? 1 : 0) != 0);
        try {
            em.flush();
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        project = (Project)em.find(Project.class, (Object)project.getId());
        lproject = (LargeProject)em.find(LargeProject.class, (Object)lproject.getId());
        sproject = (SmallProject)em.find(SmallProject.class, (Object)sproject.getId());
        this.closeEntityManager(em);
        AdvancedJPAJunitTest.assertTrue((String)"Project's default constructor wasn't used to create managed entity", (project.getFieldOnlySetThroughConstructor() == 1 ? 1 : 0) != 0);
        AdvancedJPAJunitTest.assertTrue((String)"LargeProject's default constructor wasn't used to create managed entity", (lproject.getFieldOnlySetThroughConstructor() == 2 ? 1 : 0) != 0);
        AdvancedJPAJunitTest.assertTrue((String)"Project's default constructor wasn't used to create managed SmallProject", (sproject.getFieldOnlySetThroughConstructor() == 1 ? 1 : 0) != 0);
    }

    public void testVerifyEmployeeCustomizerSettings() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        ClassDescriptor descriptor = AdvancedJPAJunitTest.getServerSession((String)"fieldaccess").getDescriptorForAlias("Employee");
        if (descriptor == null) {
            AdvancedJPAJunitTest.fail((String)"A descriptor for the Employee alias was not found.");
        } else {
            AdvancedJPAJunitTest.assertFalse((String)"Disable cache hits was true. Customizer should have made it false.", (boolean)descriptor.shouldDisableCacheHits());
        }
        this.closeEntityManager(em);
    }

    public void testVerifyEmployeeManagerMappings() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        ClassDescriptor descriptor = AdvancedJPAJunitTest.getServerSession((String)"fieldaccess").getDescriptorForAlias("Employee");
        if (descriptor == null) {
            AdvancedJPAJunitTest.fail((String)"A descriptor for the Employee alias was not found.");
        } else {
            AdvancedJPAJunitTest.assertNotNull((String)"The isManager mapping was not found on the Employee descriptor.", (Object)descriptor.getMappingForAttributeName("isManager"));
            AdvancedJPAJunitTest.assertNotNull((String)"The getManager mapping was not found on the Employee descriptor.", (Object)descriptor.getMappingForAttributeName("getManager"));
            AdvancedJPAJunitTest.assertNotNull((String)"The setManager mapping was not found on the Employee descriptor.", (Object)descriptor.getMappingForAttributeName("setManager"));
        }
        this.closeEntityManager(em);
    }

    public void testJoinFetchAnnotation() {
        ServerSession session = JUnitTestCase.getServerSession((String)"fieldaccess");
        ClassDescriptor descriptor = session.getDescriptor(Employee.class);
        if (((ForeignReferenceMapping)descriptor.getMappingForAttributeName("department")).getJoinFetch() != 2) {
            AdvancedJPAJunitTest.fail((String)"JoinFetch annotation not read correctly for Employee.department.");
        }
    }

    public void testUpdateEmployee() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllFieldAccessSQLEmployees");
            Collection employees = query.getResultCollection();
            if (employees.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No Employees were found. Test requires at least one Employee to be created in the EmployeePopulator.");
            } else {
                Employee emp = (Employee)employees.iterator().next();
                emp.addResponsibility(newResponsibility);
                emp.setMondayToFridayWorkWeek();
                empId = emp.getId();
                this.commitTransaction(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyUpdatedEmployee() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)empId);
            AdvancedJPAJunitTest.assertNotNull((String)"The updated employee was not found.", (Object)emp);
            boolean found = false;
            for (String responsibility : emp.getResponsibilities()) {
                if (!responsibility.equals(newResponsibility)) continue;
                found = true;
                break;
            }
            this.commitTransaction(em);
            AdvancedJPAJunitTest.assertTrue((String)"The new responsibility was not added.", (boolean)found);
            AdvancedJPAJunitTest.assertTrue((String)"The basic collection using enums was not persisted correctly.", (boolean)emp.worksMondayToFriday());
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateNewBuyer() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            GoldBuyer buyer = new GoldBuyer();
            buyer.setName("Guy Pelletier");
            buyer.setGender("Made of testosterone");
            buyer.setDescription("Loves to spend");
            buyer.addVisa(visa);
            buyer.addAmex(amex);
            buyer.addDinersClub(diners);
            buyer.addMastercard(mastercard);
            buyer.setSaturdayToSundayBuyingDays();
            em.persist((Object)buyer);
            this.commitTransaction(em);
            buyerId = buyer.getId();
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testVerifyNewBuyer() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            GoldBuyer buyer = (GoldBuyer)em.find(GoldBuyer.class, (Object)buyerId);
            AdvancedJPAJunitTest.assertNotNull((String)"The new buyer was not found", (Object)buyer);
            AdvancedJPAJunitTest.assertTrue((String)"Gender was not persisted correctly.", (boolean)buyer.isMale());
            AdvancedJPAJunitTest.assertTrue((String)"Visa card did not persist correctly.", (boolean)buyer.hasVisa(visa));
            AdvancedJPAJunitTest.assertTrue((String)"Amex card did not persist correctly.", (boolean)buyer.hasAmex(amex));
            AdvancedJPAJunitTest.assertTrue((String)"Diners Club card did not persist correctly.", (boolean)buyer.hasDinersClub(diners));
            AdvancedJPAJunitTest.assertTrue((String)"Mastercard card did not persist correctly.", (boolean)buyer.hasMastercard(mastercard));
            AdvancedJPAJunitTest.assertTrue((String)"The serialized enum set was not persisted correctly.", (boolean)buyer.buysSaturdayToSunday());
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testBuyerOptimisticLocking() {
        if (AdvancedJPAJunitTest.isOnServer()) {
            return;
        }
        EntityManager em1 = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        EntityManager em2 = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        em1.getTransaction().begin();
        em2.getTransaction().begin();
        RuntimeException caughtException = null;
        try {
            GoldBuyer buyer1 = (GoldBuyer)em1.find(GoldBuyer.class, (Object)buyerId);
            GoldBuyer buyer2 = (GoldBuyer)em2.find(GoldBuyer.class, (Object)buyerId);
            buyer1.setName("Geezer");
            buyer2.setName("Guyzer");
            buyer1.setVersion(buyer1.getVersion() + 1);
            buyer2.setVersion(buyer2.getVersion() + 1);
            em1.getTransaction().commit();
            em2.getTransaction().commit();
            em1.close();
            em2.close();
        }
        catch (RuntimeException e) {
            caughtException = e;
            if (em1.getTransaction().isActive()) {
                em1.getTransaction().rollback();
            }
            if (em2.getTransaction().isActive()) {
                em2.getTransaction().rollback();
            }
            em1.close();
            em2.close();
        }
        if (caughtException == null) {
            AdvancedJPAJunitTest.fail((String)"Optimistic lock exception was not thrown.");
        } else if (!(caughtException.getCause() instanceof OptimisticLockException)) {
            throw caughtException;
        }
    }

    public void testGiveFredAnObjectTypeConverterChange() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllFieldAccessEmployeesByFirstName");
            query.setParameter("firstname", (Object)"Fred");
            Collection employees = query.getResultCollection();
            if (employees.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No employees named Fred were found. Test requires at least one Fred to be created in the EmployeePopulator.");
            } else {
                Employee fred = (Employee)employees.iterator().next();
                fred.setFemale();
                fred.setFirstName("Penelope");
                penelopeId = fred.getId();
                this.commitTransaction(em);
                AdvancedJPAJunitTest.clearCache((String)"fieldaccess");
                em.clear();
                Employee penelope = (Employee)em.find(Employee.class, (Object)penelopeId);
                AdvancedJPAJunitTest.assertTrue((String)"Fred's ObjectTypeConverter change to Penelope didn't occur.", (boolean)penelope.isFemale());
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testUpdatePenelopesPhoneNumberStatus() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Employee emp = (Employee)em.find(Employee.class, (Object)penelopeId);
            AdvancedJPAJunitTest.assertNotNull((String)("The employee with id: [" + penelopeId + "] was not found."), (Object)emp);
            for (PhoneNumber phoneNumber : emp.getPhoneNumbers()) {
                phoneNumber.addStatus(PhoneNumber.PhoneStatus.ACTIVE);
                phoneNumber.addStatus(PhoneNumber.PhoneStatus.ASSIGNED);
            }
            this.commitTransaction(em);
            AdvancedJPAJunitTest.clearCache((String)"fieldaccess");
            em.clear();
            Employee emp2 = (Employee)em.find(Employee.class, (Object)penelopeId);
            for (PhoneNumber phone : emp2.getPhoneNumbers()) {
                AdvancedJPAJunitTest.assertTrue((String)"", (boolean)phone.getStatus().contains(PhoneNumber.PhoneStatus.ACTIVE));
                AdvancedJPAJunitTest.assertTrue((String)"", (boolean)phone.getStatus().contains(PhoneNumber.PhoneStatus.ASSIGNED));
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testRemoveJillWithPrivateOwnedPhoneNumbers() {
        if (AdvancedJPAJunitTest.getServerSession((String)"fieldaccess").getPlatform().isSymfoware()) {
            AdvancedJPAJunitTest.getServerSession((String)"fieldaccess").logMessage("Test testRemoveJillWithPrivateOwnedPhoneNumbers skipped for this platform, The CascadeOnDelete doesn't work on a relation where CascadeType.Remove or CascadeType.All is specified on Symfoware Platform.");
            return;
        }
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllFieldAccessEmployeesByFirstName");
            query.setParameter("firstname", (Object)"Jill");
            Collection employees = query.getResultCollection();
            if (employees.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No employees named Jill were found. Test requires at least one Jill to be created in the EmployeePopulator.");
            } else {
                Employee jill = (Employee)employees.iterator().next();
                Collection phoneNumbers = jill.getPhoneNumbers();
                if (phoneNumbers.isEmpty()) {
                    AdvancedJPAJunitTest.fail((String)"Jill does not have any phone numbers. Test requires that Jill have atleast one phone number created in the EmployeePopulator.");
                }
                for (Employee employee : jill.getManagedEmployees()) {
                    employee.setManager(jill.getManager());
                }
                jill.getManagedEmployees().clear();
                int jillId = jill.getId();
                em.remove((Object)jill);
                this.commitTransaction(em);
                AdvancedJPAJunitTest.assertNull((String)"Jill herself was not removed.", (Object)em.find(Employee.class, (Object)jillId));
                for (PhoneNumber phoneNumber : phoneNumbers) {
                    AdvancedJPAJunitTest.assertNull((String)"Jill's phone numbers were not deleted.", (Object)em.find(PhoneNumber.class, (Object)phoneNumber.buildPK()));
                }
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testCreateNewEquipment() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Equipment equip1 = new Equipment();
            equip1.setDescription("Toaster");
            em.persist((Object)equip1);
            Equipment equip2 = new Equipment();
            equip1.setDescription("Bucket");
            em.persist((Object)equip2);
            Equipment equip3 = new Equipment();
            equip1.setDescription("Broom");
            em.persist((Object)equip3);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testAddNewEquipmentToDepartment() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            EJBQueryImpl query = (EJBQueryImpl)em.createNamedQuery("findAllSQLEquipment");
            Collection equipment = query.getResultCollection();
            if (equipment.isEmpty()) {
                AdvancedJPAJunitTest.fail((String)"No Equipment was found. testCreateNewEquipment should have created new equipment and should have run before this test.");
            } else {
                Department department = new Department();
                department.setName("Department with equipment");
                for (Equipment e : equipment) {
                    department.addEquipment(e);
                }
                em.persist((Object)department);
                deptId = department.getId();
                this.commitTransaction(em);
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQuery() {
        if (!AdvancedJPAJunitTest.supportsStoredProcedures((String)"fieldaccess")) {
            return;
        }
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Query aQuery = em.createNamedQuery("SProcAddress").setParameter("ADDRESS_ID", (Object)address1.getId());
            Address address2 = (Address)aQuery.getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            AdvancedJPAJunitTest.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address not found using stored procedure", (address1.getId().intValue() == address2.getId().intValue() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.getStreet().endsWith(address2.getStreet()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryInOut() {
        if (!AdvancedJPAJunitTest.supportsStoredProcedures((String)"fieldaccess")) {
            return;
        }
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            em.clear();
            Query aQuery = em.createNamedQuery("SProcInOut").setParameter("ADDRESS_ID", (Object)address1.getId());
            Address address2 = (Address)aQuery.getSingleResult();
            AdvancedJPAJunitTest.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
            AdvancedJPAJunitTest.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address not found using stored procedure", (address1.getId().intValue() == address2.getId().intValue() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.getStreet().equals(address2.getStreet()));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQueryWithRawData() {
        if (!AdvancedJPAJunitTest.supportsStoredProcedures((String)"fieldaccess")) {
            return;
        }
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Address address1 = new Address();
            address1.setCity("Ottawa");
            address1.setPostalCode("K1G6P3");
            address1.setProvince("ON");
            address1.setStreet("123 Street");
            address1.setCountry("Canada");
            em.persist((Object)address1);
            this.commitTransaction(em);
            Query aQuery = em.createNamedQuery("SProcInOutReturningRawData").setParameter("ADDRESS_ID", (Object)address1.getId());
            Object[] objectdata = (Object[])aQuery.getSingleResult();
            AdvancedJPAJunitTest.assertTrue((String)"Address data not found or returned using stored procedure", (objectdata != null && objectdata.length == 2 ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address Id data returned doesn't match persisted address", (address1.getId().intValue() == ((Integer)objectdata[0]).intValue() ? 1 : 0) != 0);
            AdvancedJPAJunitTest.assertTrue((String)"Address Street data returned doesn't match persisted address", (boolean)address1.getStreet().equals(objectdata[1]));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testRemoveDepartmentWithPrivateOwnedEquipment() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Department department = (Department)em.find(Department.class, (Object)deptId);
            if (department == null) {
                AdvancedJPAJunitTest.fail((String)("Department with id=" + deptId + ", was not found."));
            } else {
                Collection equipment = department.getEquipment().values();
                if (equipment.isEmpty()) {
                    AdvancedJPAJunitTest.fail((String)("Department with id=" + deptId + ", did not have any equipment."));
                } else {
                    em.remove((Object)department);
                    this.commitTransaction(em);
                    AdvancedJPAJunitTest.assertNull((String)"Department itself was not removed.", (Object)em.find(Department.class, (Object)deptId));
                    for (Equipment e : equipment) {
                        AdvancedJPAJunitTest.assertNull((String)"New equipment was not deleted.", (Object)em.find(Equipment.class, (Object)e.getId()));
                    }
                }
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    public void testUpdateReadOnlyEquipmentCode() {
        EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
        this.beginTransaction(em);
        try {
            Query query = em.createNamedQuery("findSQLEquipmentCodeA");
            EquipmentCode equipmentCode = (EquipmentCode)query.getSingleResult();
            equipmentCode.setCode("Z");
            this.commitTransaction(em);
            try {
                query = em.createNamedQuery("findSQLEquipmentCodeA");
                query.getSingleResult();
            }
            catch (Exception e) {
                AdvancedJPAJunitTest.fail((String)"The read only EquipmentA was modified");
            }
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.closeEntityManager(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPessimisticLockingNamedQuery() {
        ServerSession session = JUnitTestCase.getServerSession((String)"fieldaccess");
        if (!AdvancedJPAJunitTest.isOnServer() && AdvancedJPAJunitTest.isSelectForUpateNoWaitSupported((String)"fieldaccess") && !session.getPlatform().isSQLServer()) {
            Employee employee;
            EntityManager em = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
            try {
                this.beginTransaction(em);
                employee = new Employee();
                employee.setFirstName("Lucie");
                employee.setLastName("Ogdensburgh");
                em.persist((Object)employee);
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw ex;
            }
            PersistenceException lockTimeoutException = null;
            try {
                block16: {
                    this.beginTransaction(em);
                    employee = (Employee)em.createNamedQuery("findFieldAccessEmployeeByPK").setParameter("id", (Object)employee.getId()).getSingleResult();
                    EntityManager em2 = AdvancedJPAJunitTest.createEntityManager((String)"fieldaccess");
                    try {
                        this.beginTransaction(em2);
                        Employee emp2 = (Employee)em2.find(Employee.class, (Object)employee.getId(), LockModeType.PESSIMISTIC_READ);
                    }
                    catch (PersistenceException ex) {
                        if (ex instanceof LockTimeoutException) {
                            lockTimeoutException = ex;
                            break block16;
                        }
                        throw ex;
                    }
                    finally {
                        this.closeEntityManagerAndTransaction(em2);
                    }
                }
                this.commitTransaction(em);
            }
            catch (RuntimeException ex) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw ex;
            }
            finally {
                this.closeEntityManager(em);
            }
            AdvancedJPAJunitTest.assertFalse((String)"A lock timeout exception was not thrown (likely because the persistence unit lock timeout default property was not processed).", (lockTimeoutException == null ? 1 : 0) != 0);
        }
    }

    static {
        visa = 1234567890L;
        amex = 1987654321L;
        diners = 1192837465L;
        mastercard = 1647382910L;
        newResponsibility = "The most useless responsibility ever.";
    }
}

