/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm;

import java.util.ArrayList;
import org.eclipse.persistence.tools.utility.StringTools;

public enum ORMDocumentType {
    ECLIPELINK_1_2("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "1.2", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_1_2.xsd"),
    ECLIPELINK_2_0("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "2.0", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_0.xsd"),
    ECLIPELINK_2_1("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "2.1", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_1.xsd"),
    ECLIPELINK_2_2("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "2.2", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_2.xsd"),
    ECLIPELINK_2_3("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "2.3", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_3.xsd"),
    ECLIPELINK_2_4("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "2.4", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_4.xsd"),
    ECLIPELINK_2_5("http://www.eclipse.org/eclipselink/xsds/persistence/orm", "2.5", "http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_2_5.xsd"),
    JPA_1_0("http://java.sun.com/xml/ns/persistence/orm", "1.0", "http://java.sun.com/xml/ns/persistence/orm_1_0.xsd"),
    JPA_2_0("http://java.sun.com/xml/ns/persistence/orm", "2.0", "http://java.sun.com/xml/ns/persistence/orm_2_0.xsd"),
    JPA_2_1("http://java.sun.com/xml/ns/persistence/orm", "2.1", "http://java.sun.com/xml/ns/persistence/orm_2_1.xsd"),
    UNKNOWN("http://java.sun.com/xml/ns/persistence/orm", "2.0", "http://java.sun.com/xml/ns/persistence/orm_2_0.xsd");

    private String schemaURI;
    private String version;
    private String xmlNamespace;

    private ORMDocumentType(String xmlNamespace, String version, String schemaURI) {
        this.xmlNamespace = xmlNamespace;
        this.version = version;
        this.schemaURI = schemaURI;
    }

    public static Iterable<ORMDocumentType> types() {
        ArrayList<ORMDocumentType> types = new ArrayList<ORMDocumentType>();
        types.add(JPA_1_0);
        types.add(JPA_2_0);
        types.add(JPA_2_1);
        types.add(ECLIPELINK_1_2);
        types.add(ECLIPELINK_2_0);
        types.add(ECLIPELINK_2_1);
        types.add(ECLIPELINK_2_2);
        types.add(ECLIPELINK_2_3);
        types.add(ECLIPELINK_2_4);
        types.add(ECLIPELINK_2_5);
        return types;
    }

    public static ORMDocumentType value(String xmlNamespace, String version, String schemaURI) {
        for (ORMDocumentType type : ORMDocumentType.types()) {
            if (!StringTools.equalsIgnoreCase((String)schemaURI, (String)type.schemaURI) && (!StringTools.equalsIgnoreCase((String)type.xmlNamespace, (String)xmlNamespace) || !StringTools.equalsIgnoreCase((String)type.version, (String)version))) continue;
            return type;
        }
        return UNKNOWN;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public String getVersion() {
        return this.version;
    }

    public String getXmlNamespace() {
        return this.xmlNamespace;
    }

    public String toString() {
        return this.version;
    }
}

