/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalNamedQuery;
import org.eclipse.persistence.tools.mapping.orm.ExternalQueryHint;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.dom.QueryHint;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

abstract class Query
extends AbstractExternalForm
implements ExternalNamedQuery {
    private int index;
    static final String DESCRIPTION = "description";
    static final String NAME = "name";
    static final String QUERY = "query";

    Query(Entity parent, int index) {
        super(parent);
        this.index = index;
    }

    Query(ORMConfiguration parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public final void addQueryHint(int index, String name, String value) {
        QueryHint queryHint = this.buildQueryHint(index);
        queryHint.addSelf();
        queryHint.setName(name);
        queryHint.setValue(value);
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(QUERY);
        names.add("hint");
        return names;
    }

    private QueryHint buildQueryHint(int index) {
        return new QueryHint(this, index);
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public final Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public final String getQuery() {
        return this.getChildTextNode(QUERY);
    }

    @Override
    public final QueryHint getQueryHint(int index) {
        Element element = this.getChild("hint", index);
        if (element != null) {
            return this.buildQueryHint(index);
        }
        return null;
    }

    @Override
    public final ListIterable<ExternalQueryHint> queryHints() {
        int count = this.queryHintsSize();
        ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>(count);
        int index = count;
        while (--index >= 0) {
            QueryHint queryHint = this.buildQueryHint(index);
            queryHints.add(0, queryHint);
        }
        return new ListListIterable(queryHints);
    }

    @Override
    public final int queryHintsSize() {
        return this.getChildrenSize("hint");
    }

    @Override
    public final void removeQueryHint(int index) {
        QueryHint queryHint = this.buildQueryHint(index);
        queryHint.removeSelf();
    }

    @Override
    public final void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public final void setName(String name) {
        this.setAttribute(NAME, name);
    }

    @Override
    public final void setQuery(String query) {
        this.updateChildTextNode(QUERY, query);
    }
}

