/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalColumnResult;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityResult;
import org.eclipse.persistence.tools.mapping.orm.ExternalSQLResultSetMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.ColumnResult;
import org.eclipse.persistence.tools.mapping.orm.dom.Entity;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityResult;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;
import org.eclipse.persistence.tools.utility.iterable.ListListIterable;
import org.w3c.dom.Element;

final class SQLResultSetMapping
extends AbstractExternalForm
implements ExternalSQLResultSetMapping {
    private int index;
    static final String DESCRIPTION = "description";
    static final String NAME = "name";
    static final String SQL_RESULT_SET_MAPPING = "sql-result-set-mapping";

    SQLResultSetMapping(Entity parent, int index) {
        super(parent);
        this.index = index;
    }

    SQLResultSetMapping(ORMConfiguration parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public void addColumnResult(int index, String name) {
        ColumnResult entityResult = this.buildColumnResult(index);
        entityResult.addSelf();
        entityResult.setName(name);
    }

    @Override
    public void addEntityResult(int index, String className) {
        EntityResult entityResult = this.buildEntityResult(index);
        entityResult.addSelf();
        entityResult.setEntityClassName(className);
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    private ColumnResult buildColumnResult(int index) {
        return new ColumnResult(this, index);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DESCRIPTION);
        names.add("entity-result");
        names.add("column-result");
        return names;
    }

    private EntityResult buildEntityResult(int index) {
        return new EntityResult(this, index);
    }

    @Override
    public ListIterable<ExternalColumnResult> columnResults() {
        int count = this.columnResultsSize();
        ArrayList<ColumnResult> columnResults = new ArrayList<ColumnResult>(count);
        int index = count;
        while (--index >= 0) {
            ColumnResult columnResult = this.buildColumnResult(index);
            columnResults.add(0, columnResult);
        }
        return new ListListIterable(columnResults);
    }

    @Override
    public int columnResultsSize() {
        return this.getChildrenSize("column-result");
    }

    @Override
    public ListIterable<ExternalEntityResult> entityResults() {
        int count = this.entityResultsSize();
        ArrayList<EntityResult> entityResults = new ArrayList<EntityResult>(count);
        int index = count;
        while (--index >= 0) {
            EntityResult entityResult = this.buildEntityResult(index);
            entityResults.add(0, entityResult);
        }
        return new ListListIterable(entityResults);
    }

    @Override
    public int entityResultsSize() {
        return this.getChildrenSize("entity-result");
    }

    @Override
    public ExternalColumnResult getColumnResult(int index) {
        Element element = this.getChild("column-result", index);
        if (element == null) {
            return null;
        }
        return this.buildColumnResult(index);
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode(DESCRIPTION);
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return SQL_RESULT_SET_MAPPING;
    }

    @Override
    public ExternalEntityResult getEntityResult(int index) {
        Element element = this.getChild("entity-result", index);
        if (element == null) {
            return null;
        }
        return this.buildEntityResult(index);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getName() {
        return this.getAttribute(NAME);
    }

    @Override
    public void removeColumnResult(int index) {
        EntityResult entityResult = this.buildEntityResult(index);
        entityResult.removeSelf();
    }

    @Override
    public void removeEntityResult(int index) {
        EntityResult entityResult = this.buildEntityResult(index);
        entityResult.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode(DESCRIPTION, description);
    }

    @Override
    public void setName(String name) {
        this.setAttribute(NAME, name);
    }
}

