/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.tests;

import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.CollectingExceptionHandler;
import org.eclipse.persistence.tools.utility.iterable.IterableTools;

public class CollectingExceptionHandlerTests
extends TestCase {
    public CollectingExceptionHandlerTests(String name) {
        super(name);
    }

    public void testHandleException() {
        CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
        NullPointerException npe1 = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe1);
        NullPointerException npe2 = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe2);
        Iterable exceptions = exceptionHandler.getExceptions();
        CollectingExceptionHandlerTests.assertEquals((int)2, (int)IterableTools.size((Iterable)exceptions));
    }

    public void testGetExceptions() {
        CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
        NullPointerException npe1 = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe1);
        NullPointerException npe2 = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe2);
        Iterable exceptions = exceptionHandler.getExceptions();
        CollectingExceptionHandlerTests.assertEquals((int)2, (int)IterableTools.size((Iterable)exceptions));
        CollectingExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)exceptions, (Object)npe1));
        CollectingExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)exceptions, (Object)npe2));
    }

    public void testClearExceptions() {
        CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
        NullPointerException npe1 = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe1);
        NullPointerException npe2 = new NullPointerException();
        exceptionHandler.handleException((Throwable)npe2);
        Iterable exceptions = exceptionHandler.clearExceptions();
        CollectingExceptionHandlerTests.assertEquals((int)2, (int)IterableTools.size((Iterable)exceptions));
        CollectingExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)exceptions, (Object)npe1));
        CollectingExceptionHandlerTests.assertTrue((boolean)IterableTools.contains((Iterable)exceptions, (Object)npe2));
        exceptions = exceptionHandler.clearExceptions();
        CollectingExceptionHandlerTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)exceptions));
        exceptions = exceptionHandler.getExceptions();
        CollectingExceptionHandlerTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)exceptions));
    }

    public void testToString() {
        CollectingExceptionHandler exceptionHandler = new CollectingExceptionHandler();
        CollectingExceptionHandlerTests.assertNotNull((Object)exceptionHandler.toString());
    }
}

