/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import org.eclipse.persistence.tools.utility.CharArrayTools;
import org.eclipse.persistence.tools.utility.CharacterTools;

public final class ByteArrayTools {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static String convertToHexString(byte[] bytes) {
        int bytesLength = bytes.length;
        return bytesLength == 0 ? "" : ByteArrayTools.convertToHexString(bytes, bytesLength);
    }

    private static String convertToHexString(byte[] bytes, int bytesLength) {
        return new String(ByteArrayTools.convertToHexCharArray(bytes, bytesLength));
    }

    public static char[] convertToHexCharArray(byte[] bytes) {
        int bytesLength = bytes.length;
        return bytesLength == 0 ? CharArrayTools.EMPTY_CHAR_ARRAY : ByteArrayTools.convertToHexCharArray(bytes, bytesLength);
    }

    private static char[] convertToHexCharArray(byte[] bytes, int bytesLength) {
        int stringLength = bytesLength << 1;
        char[] digits = CharacterTools.DIGITS;
        char[] string = new char[stringLength];
        int bi = bytesLength - 1;
        int si = stringLength - 2;
        while (bi >= 0) {
            int b = bytes[bi] & 0xFF;
            string[si] = digits[b >> 4];
            string[si + 1] = digits[b & 0xF];
            --bi;
            si -= 2;
        }
        return string;
    }

    private ByteArrayTools() {
        throw new UnsupportedOperationException();
    }
}

