/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.persistence.tools.utility.ObjectTools;

public class PeekableIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private E next;
    private boolean done;

    public PeekableIterator(Iterable<? extends E> iterable) {
        this(iterable.iterator());
    }

    public PeekableIterator(Iterator<? extends E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.done = false;
        this.loadNext();
    }

    @Override
    public boolean hasNext() {
        return !this.done;
    }

    @Override
    public E next() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        E result = this.next;
        this.loadNext();
        return result;
    }

    public E peek() {
        if (this.done) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        if (this.iterator.hasNext()) {
            this.next = this.iterator.next();
        } else {
            this.next = null;
            this.done = true;
        }
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.iterator);
    }
}

