/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;

public class SynchronizedIterator<E>
implements Iterator<E> {
    private final Iterator<? extends E> iterator;
    private final Object mutex;

    public SynchronizedIterator(Iterable<? extends E> iterable) {
        this(iterable.iterator());
    }

    public SynchronizedIterator(Iterable<? extends E> iterable, Object mutex) {
        this(iterable.iterator(), mutex);
    }

    public SynchronizedIterator(Iterator<? extends E> iterator) {
        if (iterator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.mutex = this;
    }

    public SynchronizedIterator(Iterator<? extends E> iterator, Object mutex) {
        if (iterator == null || mutex == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.mutex = mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasNext() {
        Object object = this.mutex;
        synchronized (object) {
            return this.iterator.hasNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized E next() {
        Object object = this.mutex;
        synchronized (object) {
            return this.iterator.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void remove() {
        Object object = this.mutex;
        synchronized (object) {
            this.iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return ObjectTools.toString((Object)this, this.iterator);
        }
    }
}

