/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.listener;

import java.lang.reflect.Method;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.model.event.ChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionAddEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionClearEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionEvent;
import org.eclipse.persistence.tools.utility.model.event.CollectionRemoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListAddEvent;
import org.eclipse.persistence.tools.utility.model.event.ListChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.ListClearEvent;
import org.eclipse.persistence.tools.utility.model.event.ListEvent;
import org.eclipse.persistence.tools.utility.model.event.ListMoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListRemoveEvent;
import org.eclipse.persistence.tools.utility.model.event.ListReplaceEvent;
import org.eclipse.persistence.tools.utility.model.event.PropertyChangeEvent;
import org.eclipse.persistence.tools.utility.model.event.StateChangeEvent;
import org.eclipse.persistence.tools.utility.model.listener.CollectionChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.ListChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.MultiMethodReflectiveChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.PropertyChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.SingleMethodReflectiveChangeListener;
import org.eclipse.persistence.tools.utility.model.listener.StateChangeListener;

public abstract class ReflectiveChangeListener {
    protected final Object target;
    protected static final Class<StateChangeEvent> STATE_CHANGE_EVENT_CLASS = StateChangeEvent.class;
    protected static final Class<StateChangeEvent>[] STATE_CHANGE_EVENT_CLASS_ARRAY = new Class[]{STATE_CHANGE_EVENT_CLASS};
    protected static final Class<PropertyChangeEvent> PROPERTY_CHANGE_EVENT_CLASS = PropertyChangeEvent.class;
    protected static final Class<PropertyChangeEvent>[] PROPERTY_CHANGE_EVENT_CLASS_ARRAY = new Class[]{PROPERTY_CHANGE_EVENT_CLASS};
    protected static final Class<CollectionEvent> COLLECTION_EVENT_CLASS = CollectionEvent.class;
    protected static final Class<CollectionEvent>[] COLLECTION_EVENT_CLASS_ARRAY = new Class[]{COLLECTION_EVENT_CLASS};
    protected static final Class<CollectionAddEvent> COLLECTION_ADD_EVENT_CLASS = CollectionAddEvent.class;
    protected static final Class<CollectionAddEvent>[] COLLECTION_ADD_EVENT_CLASS_ARRAY = new Class[]{COLLECTION_ADD_EVENT_CLASS};
    protected static final Class<CollectionRemoveEvent> COLLECTION_REMOVE_EVENT_CLASS = CollectionRemoveEvent.class;
    protected static final Class<CollectionRemoveEvent>[] COLLECTION_REMOVE_EVENT_CLASS_ARRAY = new Class[]{COLLECTION_REMOVE_EVENT_CLASS};
    protected static final Class<CollectionClearEvent> COLLECTION_CLEAR_EVENT_CLASS = CollectionClearEvent.class;
    protected static final Class<CollectionClearEvent>[] COLLECTION_CLEAR_EVENT_CLASS_ARRAY = new Class[]{COLLECTION_CLEAR_EVENT_CLASS};
    protected static final Class<CollectionChangeEvent> COLLECTION_CHANGE_EVENT_CLASS = CollectionChangeEvent.class;
    protected static final Class<CollectionChangeEvent>[] COLLECTION_CHANGE_EVENT_CLASS_ARRAY = new Class[]{COLLECTION_CHANGE_EVENT_CLASS};
    protected static final Class<ListEvent> LIST_EVENT_CLASS = ListEvent.class;
    protected static final Class<ListEvent>[] LIST_EVENT_CLASS_ARRAY = new Class[]{LIST_EVENT_CLASS};
    protected static final Class<ListAddEvent> LIST_ADD_EVENT_CLASS = ListAddEvent.class;
    protected static final Class<ListAddEvent>[] LIST_ADD_EVENT_CLASS_ARRAY = new Class[]{LIST_ADD_EVENT_CLASS};
    protected static final Class<ListRemoveEvent> LIST_REMOVE_EVENT_CLASS = ListRemoveEvent.class;
    protected static final Class<ListRemoveEvent>[] LIST_REMOVE_EVENT_CLASS_ARRAY = new Class[]{LIST_REMOVE_EVENT_CLASS};
    protected static final Class<ListReplaceEvent> LIST_REPLACE_EVENT_CLASS = ListReplaceEvent.class;
    protected static final Class<ListReplaceEvent>[] LIST_REPLACE_EVENT_CLASS_ARRAY = new Class[]{LIST_REPLACE_EVENT_CLASS};
    protected static final Class<ListMoveEvent> LIST_MOVE_EVENT_CLASS = ListMoveEvent.class;
    protected static final Class<ListMoveEvent>[] LIST_MOVE_EVENT_CLASS_ARRAY = new Class[]{LIST_MOVE_EVENT_CLASS};
    protected static final Class<ListClearEvent> LIST_CLEAR_EVENT_CLASS = ListClearEvent.class;
    protected static final Class<ListClearEvent>[] LIST_CLEAR_EVENT_CLASS_ARRAY = new Class[]{LIST_CLEAR_EVENT_CLASS};
    protected static final Class<ListChangeEvent> LIST_CHANGE_EVENT_CLASS = ListChangeEvent.class;
    protected static final Class<ListChangeEvent>[] LIST_CHANGE_EVENT_CLASS_ARRAY = new Class[]{LIST_CHANGE_EVENT_CLASS};

    private static Method findChangeListenerMethod(Object target, String methodName, Class<? extends ChangeEvent>[] eventClassArray) {
        try {
            return ObjectTools.method(target, methodName, eventClassArray);
        }
        catch (RuntimeException runtimeException) {
            return ObjectTools.method(target, methodName);
        }
    }

    private static void checkChangeListenerMethod(Method method, Class<? extends ChangeEvent> eventClass) {
        Class<?>[] parmTypes = method.getParameterTypes();
        int parmTypesLength = parmTypes.length;
        if (parmTypesLength == 0) {
            return;
        }
        if (parmTypesLength == 1 && parmTypes[0].isAssignableFrom(eventClass)) {
            return;
        }
        throw new IllegalArgumentException(method.toString());
    }

    public static StateChangeListener buildStateChangeListener(Object target, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, STATE_CHANGE_EVENT_CLASS);
        return new SingleMethodReflectiveChangeListener(target, method);
    }

    public static StateChangeListener buildStateChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildStateChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, STATE_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object target, Method method) {
        ReflectiveChangeListener.checkChangeListenerMethod(method, PROPERTY_CHANGE_EVENT_CLASS);
        return new SingleMethodReflectiveChangeListener(target, method);
    }

    public static PropertyChangeListener buildPropertyChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildPropertyChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, PROPERTY_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, Method addMethod, Method removeMethod, Method clearMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, COLLECTION_ADD_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, COLLECTION_REMOVE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(clearMethod, COLLECTION_CLEAR_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, COLLECTION_CHANGE_EVENT_CLASS);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, clearMethod, changeMethod);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, method, method, method, method);
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, String addMethodName, String removeMethodName, String clearMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, COLLECTION_ADD_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, COLLECTION_REMOVE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, clearMethodName, COLLECTION_CLEAR_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, COLLECTION_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static CollectionChangeListener buildCollectionChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildCollectionChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, COLLECTION_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object target, Method addMethod, Method removeMethod, Method replaceMethod, Method moveMethod, Method clearMethod, Method changeMethod) {
        ReflectiveChangeListener.checkChangeListenerMethod(addMethod, LIST_ADD_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(removeMethod, LIST_REMOVE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(replaceMethod, LIST_REPLACE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(moveMethod, LIST_MOVE_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(clearMethod, LIST_CLEAR_EVENT_CLASS);
        ReflectiveChangeListener.checkChangeListenerMethod(changeMethod, LIST_CHANGE_EVENT_CLASS);
        return new MultiMethodReflectiveChangeListener(target, addMethod, removeMethod, replaceMethod, moveMethod, clearMethod, changeMethod);
    }

    public static ListChangeListener buildListChangeListener(Object target, Method method) {
        return ReflectiveChangeListener.buildListChangeListener(target, method, method, method, method, method, method);
    }

    public static ListChangeListener buildListChangeListener(Object target, String addMethodName, String removeMethodName, String replaceMethodName, String moveMethodName, String clearMethodName, String changeMethodName) {
        return ReflectiveChangeListener.buildListChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, addMethodName, LIST_ADD_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, removeMethodName, LIST_REMOVE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, replaceMethodName, LIST_REPLACE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, moveMethodName, LIST_MOVE_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, clearMethodName, LIST_CLEAR_EVENT_CLASS_ARRAY), ReflectiveChangeListener.findChangeListenerMethod(target, changeMethodName, LIST_CHANGE_EVENT_CLASS_ARRAY));
    }

    public static ListChangeListener buildListChangeListener(Object target, String methodName) {
        return ReflectiveChangeListener.buildListChangeListener(target, ReflectiveChangeListener.findChangeListenerMethod(target, methodName, LIST_EVENT_CLASS_ARRAY));
    }

    protected ReflectiveChangeListener(Object target) {
        this.target = target;
    }
}

