/*******************************************************************************
 * Copyright (c) 2005, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.io;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.persistence.tools.utility.io.CompositeOutputStream;
import org.eclipse.persistence.tools.utility.tests.TestTools;

@SuppressWarnings("nls")
public class CompositeOutputStreamTests
	extends TestCase
{
	private OutputStream out1;
	private OutputStream out2;
	private OutputStream tee;


	public CompositeOutputStreamTests(String name) {
		super(name);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		this.out1 = new ByteArrayOutputStream();
		this.out2 = new ByteArrayOutputStream();
		this.tee = new CompositeOutputStream(this.out1, this.out2);
	}

	@Override
	protected void tearDown() throws Exception {
		TestTools.clear(this);
		super.tearDown();
	}

	public void testWrite() throws Exception {
		String string = "The quick brown fox jumps over the lazy dog.";
		this.tee.write(string.getBytes());
		assertEquals(string, this.out1.toString());
		assertNotSame(string, this.out1.toString());
		assertEquals(string, this.out2.toString());
		assertNotSame(string, this.out2.toString());
	}
}