/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.EnumType;
import org.eclipse.persistence.annotations.JoinFetchType;

/**
 * This interface represents the basis for all element collection mapping types defined by the
 * EclipseLink JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.5
 * @author Les Davis
 */
public interface ExternalElementCollectionMapping extends ExternalColumnMapping,
                                                          ExternalObjectCollectionMapping,
                                                          ExternalFetchableMapping {

	/**
	 * Adds a override with the given name.
	 */
	void addAssociationOverride(int index, String name);

	/**
	 * Adds a override with the given name.
	 */
	void addAttributeOverride(int index, String name);

	/**
	 * Adds a batch fetch to use.
	 */
	void addBatchFetch();

	/**
	 * Adds a collection table to this mapping.
	 */
	ExternalCollectionTable addCollectionTable();

	/**
	 * Returns the batch fetch definition for this mapping.
	 */
	ExternalBatchFetch getBatchFetch();

	/**
	 * Returns the collection table for this mapping.
	 */
	ExternalCollectionTable getCollectionTable();

	/**
	 * Returns the convert key for this mapping.
	 */
	String getConvertKey();

	/**
	 * Returns the enumerated type of this mapping if one exists.
	 */
	EnumType getEnumeratedType();

	/**
	 * Returns the join fetch type for this mapping.
	 */
	JoinFetchType getJoinFetchType();

	/**
	 * Returns the key converter for this mapping.
	 */
	ExternalConverter getKeyConverter();

	/**
	 * Returns the key object type converter for this mapping.
	 */
	ExternalObjectTypeConverter getKeyObjectTypeConverter();

	/**
	 * Returns the key struct converter for this mapping.
	 */
	ExternalStructConverter getKeyStructConverter();

	/**
	 * Returns the key type converter for this mapping.
	 */
	ExternalTypeConverter getKeyTypeConverter();

	/**
	 * Returns the target class name for this mapping.
	 */
	String getTargetClassName();
	
	/**
	 * Returns the target class short name for this mapping.
	 */
	String getTargetClassShortName();

	/**
	 * Indicates whether this basic mapping's column is a LOB.
	 */
	Boolean isLob();

	/**
	 * Removes the batch fetch.
	 */
	void removeBatchFetch();

	/**
	 * Removes the collection table from this mapping.
	 */
	void removeCollectionTable();

	/**
	 * Removes the column from this mapping.
	 */
	void removeColumn();

	/**
	 * Removes the key converter from mapping.
	 */
	void removeKeyConverter();

	/**
	 * Removes the key object type converter from mapping.
	 */
	void removeKeyObjectTypeConverter();

	/**
	 * Removes the key struct converter from mapping.
	 */
	void removeKeyStructConverter();

	/**
	 * Removes the key type converter from mapping.
	 */
	void removeKeyTypeConverter();

	/**
	 * Sets the mapping to use this converter for its key converter.
	 */
	void setAsKeyConverter(String name, String className);

	/**
	 * Sets the mapping to use this object type converter for its key converter.
	 */
	void setAsKeyObjectTypeConverter(String name);

	/**
	 * Sets the mapping to use this struct converter for its key converter.
	 */
	void setAsKeyStructConverter(String name, String converter);

	/**
	 * Sets the mapping to use this type converter for its key converter.
	 */
	void setAsKeyTypeConverter(String name);

	/**
	 * Sets the convert key.
	 */
	void setConvertKey(String value);

	/**
	 * Sets enumerated type.
	 */
	void setEnumeratedType(EnumType type);

	/**
	 * sets a join fetch type to this mapping.
	 */
	void setJoinFetchType(JoinFetchType type);

	/**
	 * Sets mapping as lob.
	 */
	void setLob(Boolean lob);

	/**
	 * Sets the target class name.
	 */
	void setTargetClassName(String className);
}