/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.distributedservers;

import java.util.Enumeration;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.WriteObjectTest;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServer;
import org.eclipse.persistence.testing.tests.distributedservers.DistributedServersModel;

public class ComplexUpdateTest
extends WriteObjectTest {
    public Object workingCopy;
    public Object distributedCopy;
    public UnitOfWork unitOfWork;

    public ComplexUpdateTest() {
    }

    public ComplexUpdateTest(Object originalObject) {
        super(originalObject);
    }

    protected void changeObject() {
    }

    public String getName() {
        return super.getName() + " " + "Distributed";
    }

    public Object getObjectFromDistributedSession(DatabaseQuery query) {
        Enumeration servers = DistributedServersModel.getDistributedServers().elements();
        while (servers.hasMoreElements()) {
            try {
                Object result = ((DistributedServer)servers.nextElement()).getDistributedSession().executeQuery(query);
                if (result == null) continue;
                return result;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public boolean isObjectValidOnDistributedServer(Object object) {
        Enumeration servers = DistributedServersModel.getDistributedServers().elements();
        while (servers.hasMoreElements()) {
            try {
                DistributedServer server = (DistributedServer)servers.nextElement();
                Object result = server.getDistributedSession().getIdentityMapAccessor().getFromIdentityMap(object);
                if (result == null) continue;
                return server.isObjectValid(object);
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    public UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    public void reset() {
        super.reset();
        Enumeration enumtr = DistributedServersModel.getDistributedServers().elements();
        while (enumtr.hasMoreElements()) {
            ((DistributedServer)enumtr.nextElement()).getDistributedSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        }
    }

    public void setUnitOfWork(UnitOfWork newUnitOfWork) {
        this.unitOfWork = newUnitOfWork;
    }

    protected void setup() {
        super.setup();
        this.distributedCopy = this.setupDistributedSessions((DatabaseQuery)this.query);
        this.setUnitOfWork(this.getSession().acquireUnitOfWork());
        this.workingCopy = this.getUnitOfWork().registerObject(this.objectToBeWritten);
    }

    public Object setupDistributedSessions(DatabaseQuery query) {
        DistributedServer server = (DistributedServer)DistributedServersModel.getDistributedServers().get(0);
        try {
            Object result = server.getDistributedSession().executeQuery(query);
            ((Employee)result).getManagedEmployees();
            ((Employee)result).getPhoneNumbers();
            ((Employee)result).getAddress();
            ((Employee)result).getManager();
            ((Employee)result).getProjects();
            ((Employee)result).getResponsibilitiesList();
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void test() {
        this.changeObject();
        if (!this.getUnitOfWork().getParent().compareObjects(this.originalObject, this.objectToBeWritten)) {
            throw new TestErrorException("The original object was changed through changing the clone.");
        }
        this.getUnitOfWork().commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.objectFromDatabase = this.getSession().executeQuery((DatabaseQuery)this.query);
        if (!((AbstractSession)this.getSession()).compareObjects(this.objectToBeWritten, this.objectFromDatabase)) {
            throw new TestErrorException("The object inserted into the database, '" + this.objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
        this.distributedCopy = this.getObjectFromDistributedSession((DatabaseQuery)this.query);
        if (!((AbstractSession)this.getSession()).compareObjects(this.distributedCopy, this.objectFromDatabase)) {
            throw new TestErrorException("The object from the distributed cache, '" + this.objectFromDatabase + "' does not match the original, '" + this.objectToBeWritten + ".");
        }
    }
}

