/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.sessionsxml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.sessionsxml.ComicsConfigTestSuite;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComicsPopulateAndQueryTestSuite {
    public static final String PACKAGE_PATH = ComicsPopulateAndQueryTestSuite.class.getPackage().getName().replace('.', '/');
    static DatabaseSession session = null;
    static DynamicHelper dynamicHelper = null;
    static Map<Integer, DynamicEntity> publishers = null;
    static Map<Integer, DynamicEntity> titles = null;
    static Map<Integer, DynamicEntity> issues = null;

    @BeforeClass
    public static void setUp() {
        session = ComicsConfigTestSuite.buildComicsSession();
        Assert.assertNotNull((Object)session);
        dynamicHelper = new DynamicHelper(session);
        SchemaManager sm = new SchemaManager(session);
        sm.replaceDefaultTables();
        sm.replaceSequences();
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE ISSUE");
        session.executeNonSelectingSQL("DROP TABLE TITLE");
        session.executeNonSelectingSQL("DROP TABLE PUBLISHER");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void populate() {
        UnitOfWork uow = null;
        try {
            uow = session.acquireUnitOfWork();
            URL publisherFileURL = dynamicHelper.getDynamicClassLoader().getResource(PACKAGE_PATH + "/publisher.tab");
            publishers = this.loadPublishers((Session)session, publisherFileURL);
            this.persist(uow, publishers);
            URL titleFileURL = this.getClass().getClassLoader().getResource(PACKAGE_PATH + "/title.tab");
            titles = this.loadTitles((Session)session, titleFileURL, publishers);
            this.persist(uow, titles);
            URL issueFileURL = this.getClass().getClassLoader().getResource(PACKAGE_PATH + "/issue.tab");
            issues = this.loadIssues((Session)session, issueFileURL, titles);
            this.persist(uow, issues);
            uow.commit();
        }
        finally {
            if (uow != null && uow.isActive()) {
                uow.release();
            }
        }
    }

    @Test
    public void countComics() {
        ReportQuery countQuery = new ReportQuery(dynamicHelper.getType("Publisher").getJavaClass(), new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)publishers.size(), (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        countQuery = new ReportQuery(dynamicHelper.getType("Title").getJavaClass(), new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)titles.size(), (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        countQuery = new ReportQuery(dynamicHelper.getType("Issue").getJavaClass(), new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)issues.size(), (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
    }

    @Test
    public void readAll() {
        session.readAllObjects(session.getDescriptorForAlias("Issue").getJavaClass());
        session.readAllObjects(session.getDescriptorForAlias("Publisher").getJavaClass());
        session.readAllObjects(session.getDescriptorForAlias("Title").getJavaClass());
    }

    protected void persist(UnitOfWork uow, Map<Integer, DynamicEntity> entities) {
        for (DynamicEntity entity : entities.values()) {
            uow.registerNewObject((Object)entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, DynamicEntity> loadIssues(Session server, URL fileURL, Map<Integer, DynamicEntity> titles) {
        DynamicType type = dynamicHelper.getType("Issue");
        HashMap<Integer, DynamicEntity> issues = new HashMap<Integer, DynamicEntity>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fileURL.openStream()));
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                DynamicEntity issue = this.buildIssue(type, nextLine, titles);
                issues.put((Integer)issue.get("id"), issue);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return issues;
    }

    protected DynamicEntity buildIssue(DynamicType issueType, String line, Map<Integer, DynamicEntity> titles) {
        String[] columns = line.split("\t");
        DynamicEntity issue = issueType.newDynamicEntity();
        issue.set("number", (Object)Integer.valueOf(columns[1]));
        issue.set("condition", (Object)columns[3]);
        issue.set("comments", (Object)columns[4]);
        String numCopiesString = columns[5];
        if (numCopiesString.length() > 0) {
            issue.set("copies", (Object)Integer.valueOf(numCopiesString));
        }
        issue.set("id", (Object)Integer.valueOf(columns[6]));
        issue.set("title", (Object)titles.get(Integer.valueOf(columns[7])));
        return issue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, DynamicEntity> loadPublishers(Session server, URL fileURL) {
        DynamicType type = dynamicHelper.getType("Publisher");
        HashMap<Integer, DynamicEntity> publishers = new HashMap<Integer, DynamicEntity>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fileURL.openStream()));
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                DynamicEntity publisher = this.buildPublisher(type, nextLine);
                publishers.put((Integer)publisher.get("id"), publisher);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return publishers;
    }

    protected DynamicEntity buildPublisher(DynamicType publisherType, String line) {
        String[] columns = line.split("\t");
        assert (columns.length == 2);
        DynamicEntity publisher = publisherType.newDynamicEntity();
        publisher.set("name", (Object)columns[0]);
        publisher.set("id", (Object)Integer.valueOf(columns[1]));
        return publisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Integer, DynamicEntity> loadTitles(Session server, URL fileURL, Map<Integer, DynamicEntity> publishers) {
        DynamicType type = dynamicHelper.getType("Title");
        HashMap<Integer, DynamicEntity> titles = new HashMap<Integer, DynamicEntity>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(fileURL.openStream()));
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                DynamicEntity title = this.buildTitle(type, nextLine, publishers);
                titles.put((Integer)title.get("id"), title);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return titles;
    }

    protected DynamicEntity buildTitle(DynamicType type, String line, Map<Integer, DynamicEntity> publishers) {
        String[] columns = line.split("\t");
        DynamicEntity title = type.newDynamicEntity();
        title.set("name", (Object)columns[0]);
        title.set("format", (Object)columns[2]);
        title.set("id", (Object)Integer.valueOf(columns[4]));
        title.set("publisher", (Object)publishers.get(Integer.valueOf(columns[5])));
        return title;
    }
}

