/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.performance.java;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.persistence.testing.framework.PerformanceComparisonTestCase;
import org.eclipse.persistence.testing.framework.TestCase;

public class MapTest
extends PerformanceComparisonTestCase {
    protected Object[] values;
    protected int size;

    public MapTest(int size) {
        this.size = size;
        this.setName("Hashtable vs Maps size " + size + " PerformanceComparisonTest");
        this.setDescription("Compares the performance between HashMap and Hashtable.");
        this.addHashtable2Test();
        this.addHashMapTest();
        this.addLinkedMapTest();
        this.addIdentityHashMapTest();
        this.addHashSetTest();
        this.addConcurrentHashMapTest();
        this.values = new Object[size];
        for (int index = 0; index < size; ++index) {
            this.values[index] = new Object();
        }
    }

    public void test() throws Exception {
        int index;
        Hashtable<Object, Object> table = new Hashtable<Object, Object>(10);
        for (index = 0; index < this.size; ++index) {
            table.put(this.values[index], this.values[index]);
        }
        for (index = 0; index < this.size; ++index) {
            Object result = table.get(this.values[index]);
        }
        for (index = 0; index < this.size; ++index) {
            Object v = table.remove(this.values[index]);
        }
    }

    public void addHashMapTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                HashMap<Object, Object> map = new HashMap<Object, Object>(10);
                for (index = 0; index < MapTest.this.size; ++index) {
                    map.put(MapTest.this.values[index], MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object result = map.get(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object v = map.remove(MapTest.this.values[index]);
                }
            }
        };
        test.setName("HashMapTest");
        this.addTest((TestCase)test);
    }

    public void addHashtable2Test() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                Hashtable<Object, Object> map = new Hashtable<Object, Object>(10);
                for (index = 0; index < MapTest.this.size; ++index) {
                    map.put(MapTest.this.values[index], MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object result = map.get(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object v = map.remove(MapTest.this.values[index]);
                }
            }
        };
        test.setName("Hashtable2Test");
        this.addTest((TestCase)test);
    }

    public void addLinkedMapTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(10);
                for (index = 0; index < MapTest.this.size; ++index) {
                    map.put(MapTest.this.values[index], MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object result = map.get(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object v = map.remove(MapTest.this.values[index]);
                }
            }
        };
        test.setName("LinkedMapTest");
        test.setAllowableDecrease(-20.0);
        this.addTest((TestCase)test);
    }

    public void addIdentityHashMapTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                IdentityHashMap<Object, Object> map = new IdentityHashMap<Object, Object>(10);
                for (index = 0; index < MapTest.this.size; ++index) {
                    map.put(MapTest.this.values[index], MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object result = map.get(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object v = map.remove(MapTest.this.values[index]);
                }
            }
        };
        test.setName("IdentityHashMapTest");
        test.setAllowableDecrease(-60.0);
        this.addTest((TestCase)test);
    }

    public void addConcurrentHashMapTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                ConcurrentHashMap<Object, Object> map = new ConcurrentHashMap<Object, Object>(10);
                for (index = 0; index < MapTest.this.size; ++index) {
                    map.put(MapTest.this.values[index], MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object result = map.get(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    Object v = map.remove(MapTest.this.values[index]);
                }
            }
        };
        test.setName("ConcurrentHashMapTest");
        test.setAllowableDecrease(-5.0);
        this.addTest((TestCase)test);
    }

    public void addHashSetTest() {
        PerformanceComparisonTestCase test = new PerformanceComparisonTestCase(){

            public void test() {
                int index;
                HashSet<Object> map = new HashSet<Object>(10);
                for (index = 0; index < MapTest.this.size; ++index) {
                    map.add(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    boolean result = map.contains(MapTest.this.values[index]);
                }
                for (index = 0; index < MapTest.this.size; ++index) {
                    boolean bl = map.remove(MapTest.this.values[index]);
                }
            }
        };
        test.setName("HashSetTest");
        test.setAllowableDecrease(0.0);
        this.addTest((TestCase)test);
    }
}

