/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.math.BigDecimal;
import java.util.Vector;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class NestedUnitOfWorkDeleteConformedNestedNewObjectTest
extends AutoVerifyTestCase {
    public NestedUnitOfWorkDeleteConformedNestedNewObjectTest() {
        this.setDescription("Test designed to verify that a new object registered in a nested unit of work is unregistered when deleted in same unit of work.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
    }

    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        UnitOfWork nestedUow1 = uow.acquireUnitOfWork();
        Employee employee = (Employee)new EmployeePopulator().basicEmployeeExample1();
        employee.setId(new BigDecimal(15));
        nestedUow1.registerObject((Object)employee);
        nestedUow1.commit();
        nestedUow1 = uow.acquireUnitOfWork();
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        query.setSelectionCriteria(new ExpressionBuilder().get("id").equal((Object)new BigDecimal(15)));
        query.conformResultsInUnitOfWork();
        Vector results = (Vector)nestedUow1.executeQuery((DatabaseQuery)query);
        if (results.size() > 1) {
            throw new TestErrorException("The read all query on primary key returned more than one object see bug # 3183379");
        }
        Employee nestedEmployee = (Employee)results.firstElement();
        nestedUow1.deleteObject((Object)nestedEmployee);
        nestedUow1.commit();
        if (!((UnitOfWorkImpl)uow).getNewObjectsCloneToOriginal().isEmpty()) {
            throw new TestErrorException("Failed to unregister the Object in the nested unit of work");
        }
    }

    public void reset() {
        this.getAbstractSession().commitTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

