/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalAssociationOverride;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinTable;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class AssociationOverride
extends AbstractExternalForm
implements ExternalAssociationOverride {
    private int index;

    AssociationOverride(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    public ExternalJoinTable addJoinTable(String tableName) {
        JoinTable joinTable = this.buildJoinTable();
        joinTable.addSelf();
        joinTable.setName(tableName);
        return joinTable;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("join-column");
        names.add("join-table");
        return names;
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, "join-column", index);
    }

    private JoinTable buildJoinTable() {
        return new JoinTable(this);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "association-override";
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public ExternalJoinTable getJoinTable() {
        if (this.hasChild("join-table")) {
            return this.buildJoinTable();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }
}

