/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.TemporalType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBasicMapping;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.ExternalMappingVisitor;
import org.eclipse.persistence.tools.mapping.orm.ExternalNoSqlField;
import org.eclipse.persistence.tools.mapping.orm.ExternalSequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.ConvertibleMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.Embeddable;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.EntityIDGeneratedValue;
import org.eclipse.persistence.tools.mapping.orm.dom.NoSqlField;
import org.eclipse.persistence.tools.mapping.orm.dom.SequenceGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.TableGenerator;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class BasicMapping
extends ConvertibleMapping
implements ExternalBasicMapping {
    BasicMapping(Embeddable parent) {
        super(parent);
    }

    @Override
    public void accept(ExternalMappingVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExternalEntityColumn addColumn() {
        EntityColumn column = this.buildColumn();
        column.addSelf();
        return column;
    }

    @Override
    public ExternalEntityIDGeneratedValue addGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.addSelf();
        return generatedValue;
    }

    @Override
    public ExternalSequenceGenerator addSequenceGenerator() {
        SequenceGenerator sequenceGenerator = this.buildSequenceGenerator();
        sequenceGenerator.addSelf();
        return sequenceGenerator;
    }

    @Override
    public ExternalTableGenerator addTableGenerator() {
        TableGenerator tableGenerator = this.buildTableGenerator();
        tableGenerator.addSelf();
        return tableGenerator;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("fetch");
        names.add("optional");
        names.add("access");
        names.add("mutable");
        names.add("attribute-type");
        return names;
    }

    private EntityColumn buildColumn() {
        return new EntityColumn(this, "column", -1);
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("column");
        names.add("field");
        names.add("generated-value");
        names.add("lob");
        names.add("temporal");
        names.add("enumerated");
        names.add("convert");
        names.add("converter");
        names.add("type-converter");
        names.add("object-type-converter");
        names.add("struct-converter");
        names.add("table-generator");
        names.add("sequence-generator");
        names.add("property");
        names.add("access-methods");
        names.add("return-insert");
        names.add("return-update");
        return names;
    }

    private EntityIDGeneratedValue buildGeneratedValue() {
        return new EntityIDGeneratedValue(this);
    }

    private ExternalNoSqlField buildNoSqlField() {
        return new NoSqlField(this);
    }

    private SequenceGenerator buildSequenceGenerator() {
        return new SequenceGenerator(this, -1);
    }

    private TableGenerator buildTableGenerator() {
        return new TableGenerator(this, -1);
    }

    @Override
    public ExternalEntityColumn getColumn() {
        return this.buildColumn();
    }

    @Override
    protected String getElementName() {
        return "basic";
    }

    @Override
    public EnumType getEnumeratedType() {
        return this.getChildEnumNode("enumerated", EnumType.class);
    }

    @Override
    public TextRange getEnumeratedTypeTextRange() {
        return this.getChildTextNodeTextRange("enumerated");
    }

    @Override
    public FetchType getFetchType() {
        return this.getEnumAttribute("fetch", FetchType.class);
    }

    @Override
    public TextRange getFetchTypeTextRange() {
        return this.getAttributeTextRange("fetch");
    }

    @Override
    public ExternalEntityIDGeneratedValue getGeneratedValue() {
        if (this.hasChild("generated-value")) {
            return this.buildGeneratedValue();
        }
        return null;
    }

    @Override
    public TextRange getLobTextRange() {
        return this.getChildTextNodeTextRange("lob");
    }

    @Override
    public TextRange getMutableTextRange() {
        return this.getAttributeTextRange("mutable");
    }

    @Override
    public String getNoSqlField() {
        ExternalNoSqlField field = this.buildNoSqlField();
        return field.getName();
    }

    @Override
    public TextRange getOptionalTextRange() {
        return this.getAttributeTextRange("optional");
    }

    @Override
    public TextRange getReturnOnInsertTextRange() {
        return this.getChildTextRange("return-insert");
    }

    @Override
    public TextRange getReturnOnlyOnInsertTextRange() {
        return this.getChildAttributeTextRange("return-insert", "return-only");
    }

    @Override
    public TextRange getReturnOnUpdateTextRange() {
        return this.getChildTextRange("return-update");
    }

    @Override
    public ExternalSequenceGenerator getSequenceGenerator() {
        if (this.hasChild("sequence-generator")) {
            return this.buildSequenceGenerator();
        }
        return null;
    }

    @Override
    public ExternalTableGenerator getTableGenerator() {
        if (this.hasChild("table-generator")) {
            return this.buildTableGenerator();
        }
        return null;
    }

    @Override
    public TemporalType getTemporalType() {
        return this.getChildEnumNode("temporal", TemporalType.class);
    }

    @Override
    public TextRange getTemporalTypeTextRange() {
        return this.getChildTextNodeTextRange("temporal");
    }

    @Override
    public boolean hasColumn() {
        return this.hasChild("column");
    }

    @Override
    public boolean isBasicMapping() {
        return true;
    }

    @Override
    public Boolean isLob() {
        return this.getChildBooleanNode("lob");
    }

    @Override
    public Boolean isMutable() {
        return this.getBooleanAttribute("mutable");
    }

    @Override
    public Boolean isOptional() {
        return this.getBooleanAttribute("optional");
    }

    @Override
    public void removeColumn() {
        EntityColumn column = this.buildColumn();
        column.removeSelf();
    }

    @Override
    public void removeGeneratedValue() {
        EntityIDGeneratedValue generatedValue = this.buildGeneratedValue();
        generatedValue.removeSelf();
    }

    @Override
    public void removeSequenceGenerator() {
        SequenceGenerator generator = this.buildSequenceGenerator();
        generator.removeSelf();
    }

    @Override
    public void removeTableGenerator() {
        TableGenerator generator = this.buildTableGenerator();
        generator.removeSelf();
    }

    @Override
    public Boolean returnOnInsert() {
        return this.hasChild("return-insert");
    }

    @Override
    public Boolean returnOnlyOnInsert() {
        return this.getChildBooleanAttribute("return-insert", "return-only");
    }

    @Override
    public Boolean returnOnUpdate() {
        return this.hasChild("return-update");
    }

    @Override
    public void setColumn(String columnName) {
        this.removeChild("column");
        if (columnName != null) {
            EntityColumn entityColumn = this.buildColumn();
            entityColumn.setName(columnName);
        }
    }

    @Override
    public void setEnumeratedType(EnumType type) {
        this.updateChildTextNode("enumerated", (Enum<?>)type);
    }

    @Override
    public void setFetchType(FetchType type) {
        this.setAttribute("fetch", (Enum<?>)type);
    }

    @Override
    public void setLob(Boolean lob) {
        this.updateChildTextNode("lob", lob);
    }

    @Override
    public void setMutable(Boolean mutable) {
        this.setAttribute("mutable", mutable);
    }

    @Override
    public void setNoSqlField(String field) {
        ExternalNoSqlField noSqlField = this.buildNoSqlField();
        noSqlField.setName(field);
    }

    @Override
    public void setOptional(Boolean optional) {
        this.setAttribute("optional", optional);
    }

    @Override
    public void setReturnOnInsert(Boolean returnOnInsert) {
        if (returnOnInsert == Boolean.TRUE) {
            this.addChild("return-insert");
        } else {
            this.removeChild("return-insert");
        }
    }

    @Override
    public void setReturnOnlyOnInsert(Boolean returnOnlyOnInsert) {
        Element element = this.getChild("return-insert");
        if (element == null && returnOnlyOnInsert == null) {
            return;
        }
        if (element != null && returnOnlyOnInsert == null) {
            this.remove(element);
        } else {
            if (element == null) {
                element = this.addChild("return-insert");
            }
            this.setAttribute(element, "return-only", returnOnlyOnInsert);
        }
    }

    @Override
    public void setReturnOnUpdate(Boolean returnOnUpdate) {
        if (returnOnUpdate == Boolean.TRUE) {
            this.addChild("return-update");
        } else {
            this.removeChild("return-update");
        }
    }

    @Override
    public void setSequenceGenerator(String generatorName) {
        this.updateChildTextNode("sequence-generator", generatorName);
    }

    @Override
    public void setTableGenerator(String generatorName) {
        this.updateChildTextNode("table-generator", generatorName);
    }

    @Override
    public void setTemporalType(TemporalType type) {
        this.updateChildTextNode("temporal", (Enum<?>)type);
    }
}

