/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalInverseJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalJoinTable;
import org.eclipse.persistence.tools.mapping.orm.dom.InverseJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.JoinColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.Table;

final class JoinTable
extends Table
implements ExternalJoinTable {
    static final String JOIN_TABLE = "join-table";

    JoinTable(AbstractExternalForm parent) {
        super(parent);
    }

    @Override
    public ExternalInverseJoinColumn addInverseJoinColumn(String name) {
        InverseJoinColumn joinColumn = this.buildInverseJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    public ExternalJoinColumn addJoinColumn(String name) {
        JoinColumn joinColumn = this.buildJoinColumn(-1);
        joinColumn.addSelf();
        joinColumn.setName(name);
        return joinColumn;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("join-column");
        names.add("inverse-join-column");
        names.add("unique-constraint");
        return names;
    }

    private InverseJoinColumn buildInverseJoinColumn(int index) {
        return new InverseJoinColumn(this, index);
    }

    private JoinColumn buildJoinColumn(int index) {
        return new JoinColumn(this, "join-column", index);
    }

    @Override
    protected String getElementName() {
        return JOIN_TABLE;
    }

    @Override
    public ExternalJoinColumn getInverseJoinColumn(int index) {
        if (this.hasChild("inverse-join-column", index)) {
            return this.buildInverseJoinColumn(index);
        }
        return null;
    }

    @Override
    public ExternalJoinColumn getJoinColumn(int index) {
        if (this.hasChild("join-column", index)) {
            return this.buildJoinColumn(index);
        }
        return null;
    }

    @Override
    public List<ExternalJoinColumn> inverseJoinColumns() {
        int count = this.inverseJoinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int inverseJoinColumnsSize() {
        return this.getChildrenSize("inverse-join-column");
    }

    @Override
    public boolean isDefault() {
        return !this.hasChildren() && !this.hasAttributes();
    }

    @Override
    public List<ExternalJoinColumn> joinColumns() {
        int count = this.joinColumnsSize();
        ArrayList<ExternalJoinColumn> joinColumns = new ArrayList<ExternalJoinColumn>(count);
        int index = 0;
        while (index < count) {
            joinColumns.add(this.buildJoinColumn(index));
            ++index;
        }
        return joinColumns;
    }

    @Override
    public int joinColumnsSize() {
        return this.getChildrenSize("join-column");
    }

    @Override
    public void removeInverseJoinColumn(int index) {
        InverseJoinColumn joinColumn = this.buildInverseJoinColumn(index);
        joinColumn.removeSelf();
    }

    @Override
    public void removeJoinColumn(int index) {
        JoinColumn joinColumn = this.buildJoinColumn(index);
        joinColumn.removeSelf();
    }
}

