/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.MultitenantType;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalMultitenancyPolicy;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalTenantTableDiscriminator;
import org.eclipse.persistence.tools.mapping.orm.dom.MappedSuperclass;
import org.eclipse.persistence.tools.mapping.orm.dom.TenantDiscriminatorColumn;
import org.eclipse.persistence.tools.mapping.orm.dom.TenantTableDiscriminator;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class MultitenancyPolicy
extends AbstractExternalForm
implements ExternalMultitenancyPolicy {
    public MultitenancyPolicy(MappedSuperclass parent) {
        super(parent);
    }

    @Override
    public ExternalTenantDiscriminatorColumn addDiscriminatorColumn() {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(-1);
        column.addSelf();
        return column;
    }

    @Override
    public ExternalTenantTableDiscriminator addTenantTableDiscriminator() {
        TenantTableDiscriminator discriminator = this.buildTenantTableDiscriminator();
        discriminator.addSelf();
        return discriminator;
    }

    private TenantDiscriminatorColumn buildDiscriminatorColumn(int index) {
        return new TenantDiscriminatorColumn(this, index);
    }

    private TenantTableDiscriminator buildTenantTableDiscriminator() {
        return new TenantTableDiscriminator(this);
    }

    @Override
    public List<ExternalTenantDiscriminatorColumn> discriminatorColumns() {
        int count = this.discriminatorColumnSize();
        ArrayList<ExternalTenantDiscriminatorColumn> columns = new ArrayList<ExternalTenantDiscriminatorColumn>(count);
        int index = 0;
        while (index < count) {
            columns.add(this.buildDiscriminatorColumn(index));
            ++index;
        }
        return columns;
    }

    @Override
    public int discriminatorColumnSize() {
        return this.getChildrenSize("tenant-discriminator-column");
    }

    @Override
    public ExternalTenantDiscriminatorColumn getDiscriminatorColumn(int index) {
        if (this.hasChild("tenant-discriminator-column", index)) {
            return this.buildDiscriminatorColumn(index);
        }
        return null;
    }

    @Override
    protected String getElementName() {
        return "multitenant";
    }

    @Override
    public TextRange getIncludeCriteriaTextRange() {
        return this.getAttributeTextRange("include-criteria");
    }

    @Override
    public MultitenantType getMultitenantType() {
        return this.getEnumAttribute("type", MultitenantType.class);
    }

    @Override
    public TextRange getMultitenantTypeTextRange() {
        return this.getAttributeTextRange("type");
    }

    public Element getParentEntityElement() {
        return this.getParentElement();
    }

    @Override
    public ExternalTenantTableDiscriminator getTenantTableDiscriminator() {
        if (this.hasChild("tenant-table-discriminator")) {
            return this.buildTenantTableDiscriminator();
        }
        return null;
    }

    @Override
    public TextRange getTenantTableDiscriminatorTextRange() {
        return this.getChildTextRange("tenant-table-discriminator");
    }

    @Override
    public Boolean isCriteriaIncluded() {
        return this.getBooleanAttribute("include-criteria");
    }

    @Override
    public void removeDiscriminatorColumn(int index) {
        TenantDiscriminatorColumn column = this.buildDiscriminatorColumn(index);
        ((AbstractExternalForm)column).removeSelf();
    }

    @Override
    public void removeTenantTableDiscriminator() {
        TenantTableDiscriminator table = this.buildTenantTableDiscriminator();
        table.removeSelf();
    }

    @Override
    public void setIncludeCriteria(Boolean value) {
        this.setAttribute("include-criteria", value);
    }

    @Override
    public void setMultitenantType(MultitenantType type) {
        this.setAttribute("type", (Enum<?>)type);
    }
}

