/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;

final class Property
extends AbstractExternalForm
implements ExternalProperty {
    private int index;

    Property(AbstractExternalForm parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("value");
        names.add("value-type");
        return names;
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    protected Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "property";
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public String getValue() {
        return this.getAttribute("value");
    }

    @Override
    public TextRange getValueTextRange() {
        return this.getAttributeTextRange("value");
    }

    @Override
    public String getValueType() {
        return this.getAttribute("value-type");
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public void setValue(String value) {
        this.setAttribute("value", value);
    }

    @Override
    public void setValueType(String valueType) {
        this.setAttribute("value-type", valueType);
    }

    public String toString() {
        return this.getName();
    }
}

