/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalTableGenerator;
import org.eclipse.persistence.tools.mapping.orm.ExternalUniqueConstraint;
import org.eclipse.persistence.tools.mapping.orm.dom.PrimaryKeyGenerator;
import org.eclipse.persistence.tools.mapping.orm.dom.UniqueConstraint;
import org.eclipse.persistence.tools.utility.TextRange;
import org.eclipse.persistence.tools.utility.iterable.ListIterable;

final class TableGenerator
extends PrimaryKeyGenerator
implements ExternalTableGenerator {
    TableGenerator(AbstractExternalForm parent, int index) {
        super(parent, index);
    }

    @Override
    public ExternalUniqueConstraint addUniqueConstraint(ListIterable<String> columnNames) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(-1);
        uniqueConstraint.addSelf();
        uniqueConstraint.setColumnNames(columnNames);
        return uniqueConstraint;
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("name");
        names.add("table");
        names.add("catalog");
        names.add("schema");
        names.add("pk-column-name");
        names.add("value-column-name");
        names.add("pk-column-value");
        names.add("initial-value");
        names.add("allocation-size");
        return names;
    }

    private UniqueConstraint buildUniqueConstraint(int index) {
        return new UniqueConstraint(this, index);
    }

    @Override
    protected String getElementName() {
        return "table-generator";
    }

    @Override
    public String getPKColumnName() {
        return this.getAttribute("pk-column-name");
    }

    @Override
    public TextRange getPKColumnNameTextRange() {
        return this.getAttributeTextRange("pk-column-name");
    }

    @Override
    public String getPKColumnValue() {
        return this.getAttribute("pk-column-value");
    }

    @Override
    public TextRange getPKColumnValueTextRange() {
        return this.getAttributeTextRange("pk-column-value");
    }

    @Override
    public String getTableName() {
        return this.getAttribute("table");
    }

    @Override
    public TextRange getTableNameTextRange() {
        return this.getAttributeTextRange("table");
    }

    @Override
    public ExternalUniqueConstraint getUniqueConstraint(int index) {
        if (this.hasChild("unique-constraint", index)) {
            return this.buildUniqueConstraint(index);
        }
        return null;
    }

    @Override
    public String getValueColumnName() {
        return this.getAttribute("value-column-name");
    }

    @Override
    public TextRange getValueColumnNameTextRange() {
        return this.getAttributeTextRange("value-column-name");
    }

    @Override
    public void removeUniqueConstraint(int index) {
        UniqueConstraint uniqueConstraint = this.buildUniqueConstraint(index);
        uniqueConstraint.removeSelf();
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setPKColumnName(String name) {
        this.setAttribute("pk-column-name", name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setPKColumnValue(String value) {
        this.setAttribute("pk-column-value", value);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setTableName(String name) {
        this.setAttribute("table", name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public void setValueColumnName(String name) {
        this.setAttribute("value-column-name", name);
        if (this.shouldBeRemoved()) {
            this.removeSelf();
        }
    }

    @Override
    public List<ExternalUniqueConstraint> uniqueConstraints() {
        int count = this.uniqueConstraintsSize();
        ArrayList<ExternalUniqueConstraint> uniqueConstraints = new ArrayList<ExternalUniqueConstraint>(count);
        int index = 0;
        while (index < count) {
            uniqueConstraints.add(this.buildUniqueConstraint(index));
            ++index;
        }
        return uniqueConstraints;
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.getChildrenSize("unique-constraint");
    }
}

