/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.persistence.tools.mapping.DefaultFormHelper;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceRepository;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceConfiguration;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.eclipse.persistence.tools.utility.iterable.EmptyIterable;
import org.w3c.dom.Document;

public final class PersistenceRepository
implements ExternalPersistenceRepository {
    public static final String PERSISTENCE_XML = "persistence.xml";

    @Override
    public ExternalPersistenceConfiguration buildPersistenceConfiguration(URL location, PersistenceDocumentType type) throws IOException {
        DefaultFormHelper helper = new DefaultFormHelper(XMLTools.newDocument(), location);
        PersistenceConfiguration persistence = new PersistenceConfiguration(helper);
        persistence.setDocumentType(type);
        return persistence;
    }

    @Override
    public ExternalPersistenceConfiguration getPersistenceConfiguration(URL location) {
        InputStream inputStream = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            DocumentBuilder documentBuilder = factory.newDocumentBuilder();
            inputStream = location.openStream();
            Document document = documentBuilder.parse(inputStream);
            DefaultFormHelper helper = new DefaultFormHelper(document, location);
            PersistenceConfiguration persistenceConfiguration = new PersistenceConfiguration(helper);
            return persistenceConfiguration;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Iterable<URL> persistenceConfigurationLocations() {
        return EmptyIterable.instance();
    }
}

