/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.ValidationMode;
import org.eclipse.persistence.tools.mapping.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.ExternalProperty;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceUnit;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.dom.Property;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.TextRange;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class PersistenceUnit
extends AbstractExternalForm
implements ExternalPersistenceUnit {
    private int index;

    PersistenceUnit(PersistenceConfiguration parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    public ExternalProperty addProperty(String name, String value) {
        Property property = this.buildProperty(-1);
        property.addSelf();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    @Override
    protected List<String> buildElementNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("description");
        names.add("provider");
        names.add("jta-data-source");
        names.add("non-jta-data-source");
        names.add("mapping-file");
        names.add("jar-file");
        names.add("class");
        names.add("exclude-unlisted-classes");
        names.add("cache-type");
        names.add("validation-mode");
        names.add("properties");
        return names;
    }

    private Property buildProperty(int index) {
        return new Property(this, index);
    }

    @Override
    protected void calculateInsertionIndex(Element parent, Element child, String elementName) {
        if (elementName == this.getElementName()) {
            this.index = this.index(parent, child, elementName);
        }
    }

    @Override
    public ExternalPersistenceUnit.CacheType getCachType() {
        return this.getChildEnumNode("cache-type", ExternalPersistenceUnit.CacheType.class);
    }

    @Override
    public TextRange getCachTypeTextRange() {
        return this.getChildTextNodeTextRange("cache-type");
    }

    @Override
    public String getDescription() {
        return this.getChildTextNode("description");
    }

    @Override
    public Element getElement() {
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return "persistence-unit";
    }

    @Override
    public TextRange getIncludedEntityClassTextRange(String className) {
        return this.getChildTextNodeTextRange("class", className);
    }

    @Override
    @Deprecated
    public int getIndex() {
        return this.index;
    }

    @Override
    public TextRange getJarFilePathTextRange(int index, String path) {
        return this.getChildTextNodeTextRange("jar-file", index, path);
    }

    @Override
    public String getJdbcDriver() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.driver");
        return property != null ? property.getValue() : null;
    }

    @Override
    public TextRange getJdbcDriverTextRange() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.driver");
        return property != null ? property.getValueTextRange() : null;
    }

    @Override
    public String getJdbcPassword() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.password");
        return property != null ? property.getValue() : null;
    }

    @Override
    public TextRange getJdbcPasswordTextRange() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.password");
        return property != null ? property.getValueTextRange() : null;
    }

    @Override
    public String getJdbcUrl() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.url");
        return property != null ? property.getValue() : null;
    }

    @Override
    public TextRange getJdbcUrlTextRange() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.url");
        return property != null ? property.getValueTextRange() : null;
    }

    @Override
    public String getJdbcUser() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.user");
        return property != null ? property.getValue() : null;
    }

    @Override
    public TextRange getJdbcUserTextRange() {
        ExternalProperty property = this.getProperty("javax.persistence.jdbc.user");
        return property != null ? property.getValueTextRange() : null;
    }

    @Override
    public String getJtaDatasource() {
        return this.getChildTextNode("jta-data-source");
    }

    @Override
    public TextRange getJtaDatasourceTextRange() {
        return this.getChildTextNodeTextRange("jta-data-source");
    }

    @Override
    public TextRange getMappedClassTextRange(String name) {
        return this.getChildTextNodeTextRange(this.getElement(), "class", name);
    }

    @Override
    public TextRange getMappingFilePathTextRange(int index, String path) {
        return this.getChildTextNodeTextRange("mapping-file", index, path);
    }

    @Override
    public String getName() {
        return this.getAttribute("name");
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getAttributeTextRange("name");
    }

    @Override
    public String getNonJtaDatasource() {
        return this.getChildTextNode("non-jta-data-source");
    }

    @Override
    public TextRange getNonJtaDatasourceTextRange() {
        return this.getChildTextNodeTextRange("non-jta-data-source");
    }

    @Override
    public Integer getPessimisticLockTimeout() {
        ExternalProperty property = this.getProperty("javax.persistence.lock.timeout");
        if (property != null) {
            try {
                return Integer.valueOf(property.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public TextRange getPessimisticLockTimeoutTextRange() {
        ExternalProperty property = this.getProperty("javax.persistence.lock.timeout");
        return property != null ? property.getValueTextRange() : null;
    }

    @Override
    public List<ExternalProperty> getProperties(String name) {
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>();
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            properties.add(property);
        }
        return properties;
    }

    @Override
    public ExternalProperty getProperty(int index) {
        Element element = this.getChild("properties");
        if (element == null) {
            return null;
        }
        if ((element = this.getChild(element, "property", index)) == null) {
            return null;
        }
        return this.buildProperty(index);
    }

    @Override
    public ExternalProperty getProperty(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public ExternalProperty getProperty(String name, int index) {
        ExternalProperty property = this.getProperty(index);
        if (property != null && ObjectTools.equals((Object)name, (Object)property.getName())) {
            return property;
        }
        return null;
    }

    @Override
    public ExternalProperty getProperty(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property;
        }
        return null;
    }

    @Override
    public TextRange getPropertyNameTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getNameTextRange();
        }
        return null;
    }

    @Override
    public TextRange getPropertyTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getTextRange();
        }
        return null;
    }

    @Override
    public TextRange getPropertyTextRange(String name, String value) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name) || !ObjectTools.equals((Object)property.getValue(), (Object)value)) continue;
            return property.getValueTextRange();
        }
        return null;
    }

    @Override
    public TextRange getPropertyValueTextRange(String name) {
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            return property.getTextRange();
        }
        return null;
    }

    @Override
    public String getProvider() {
        return this.getChildTextNode("provider");
    }

    @Override
    public TextRange getProviderTextRange() {
        return this.getChildTextNodeTextRange("provider");
    }

    @Override
    public Integer getQueryTimeout() {
        ExternalProperty property = this.getProperty("javax.persistence.query.timeout");
        if (property != null) {
            try {
                return Integer.valueOf(property.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public TextRange getQueryTimeoutTextRange() {
        ExternalProperty property = this.getProperty("javax.persistence.query.timeout");
        return property != null ? property.getValueTextRange() : null;
    }

    @Override
    public ExternalPersistenceUnit.TransactionType getTransactionType() {
        return this.getEnumAttribute("transaction-type", ExternalPersistenceUnit.TransactionType.class);
    }

    @Override
    public TextRange getTransactionTypeTextRange() {
        return this.getAttributeTextRange("transaction-type");
    }

    @Override
    public ValidationMode getValidationMode() {
        return this.getChildEnumNode("validation-mode", ValidationMode.class);
    }

    @Override
    public TextRange getValidationModeTextRange() {
        return this.getChildTextNodeTextRange("validation-mode");
    }

    @Override
    public List<String> includedClasses() {
        return this.getChildrenTextNode("class");
    }

    @Override
    public int includedClassesSize() {
        return this.getChildrenSize("class");
    }

    @Override
    public List<String> jarFiles() {
        return this.getChildrenTextNode("jar-file");
    }

    @Override
    public int jarFilesSize() {
        return this.getChildrenSize("jar-file");
    }

    @Override
    public List<String> mappingFiles() {
        return this.getChildrenTextNode("mapping-file");
    }

    @Override
    public int mappingFilesSize() {
        return this.getChildrenSize("mapping-file");
    }

    @Override
    public List<ExternalProperty> properties() {
        int count = this.propertiesSize();
        ArrayList<ExternalProperty> properties = new ArrayList<ExternalProperty>(count);
        int index = 0;
        while (index < count) {
            properties.add(this.buildProperty(index));
            ++index;
        }
        return properties;
    }

    @Override
    public int propertiesSize() {
        Element element = this.getChild("properties");
        if (element != null) {
            return this.getChildrenSize((Node)element, "property");
        }
        return 0;
    }

    @Override
    public int propertiesSize(String name) {
        int count = 0;
        for (ExternalProperty property : this.properties()) {
            if (!ObjectTools.equals((Object)property.getName(), (Object)name)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void removeProperty(int index) {
        Property property = this.buildProperty(index);
        property.removeSelf();
    }

    @Override
    public void removeProperty(String name) {
        Property property = (Property)this.getProperty(name);
        property.removeSelf();
    }

    @Override
    public void removeProperty(String name, String value) {
        Property property = (Property)this.getProperty(name, value);
        property.removeSelf();
    }

    @Override
    public void removeSelf() {
        this.removeChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    public void setCacheType(ExternalPersistenceUnit.CacheType type) {
        this.updateChildTextNode("cache-type", type);
    }

    @Override
    public void setDescription(String description) {
        this.updateChildTextNode("description", description);
    }

    @Override
    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.updateChildTextNode("exclude-unlisted-classes", excludeUnlistedClasses);
    }

    @Override
    public void setIncludedClasses(ListIterator<String> classes) {
        this.removeChildren("class");
        while (classes.hasNext()) {
            this.addChildTextNode("class", classes.next());
        }
    }

    @Override
    public void setJarFiles(ListIterator<String> jarFiles) {
        this.removeChildren("jar-file");
        while (jarFiles.hasNext()) {
            this.addChildTextNode("jar-file", jarFiles.next());
        }
    }

    @Override
    public void setJtaDatasource(String jtaDatasource) {
        this.updateChildTextNode("jta-data-source", jtaDatasource);
    }

    @Override
    public void setMappingFiles(ListIterator<String> mappingFiles) {
        this.removeChildren("mapping-file");
        while (mappingFiles.hasNext()) {
            this.addChildTextNode("mapping-file", mappingFiles.next());
        }
    }

    @Override
    public void setName(String name) {
        this.setAttribute("name", name);
    }

    @Override
    public void setNonJtaDatasource(String nonJtaDatasource) {
        this.updateChildTextNode("non-jta-data-source", nonJtaDatasource);
    }

    @Override
    public void setPessimisticLockTimeout(Integer length) {
        ExternalProperty property = this.getProperty("javax.persistence.lock.timeout");
        if (length == null && property != null) {
            this.removeProperty("javax.persistence.lock.timeout", property.getValue());
        } else if (length != null && property == null) {
            this.addProperty("javax.persistence.lock.timeout", length.toString());
        } else if (length != null && property != null) {
            property.setValue(length.toString());
        }
    }

    @Override
    public void setProvider(String provider) {
        this.updateChildTextNode("provider", provider);
    }

    @Override
    public void setQueryTimeout(Integer length) {
        ExternalProperty property = this.getProperty("javax.persistence.query.timeout");
        if (length == null && property != null) {
            this.removeProperty("javax.persistence.query.timeout", property.getValue());
        } else if (length != null && property == null) {
            this.addProperty("javax.persistence.query.timeout", length.toString());
        } else if (length != null && property != null) {
            property.setValue(length.toString());
        }
    }

    @Override
    public void setTransactionType(ExternalPersistenceUnit.TransactionType transactionType) {
        this.setAttribute("transaction-type", transactionType);
    }

    @Override
    public void setValidationMode(ValidationMode type) {
        this.updateChildTextNode("validation-mode", (Enum<?>)type);
    }

    @Override
    public boolean shouldExcludeUnlistedClasses() {
        Boolean value = this.getChildBooleanNode("exclude-unlisted-classes");
        return value != null && value != false;
    }
}

