/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.gen.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.gen.db.Column;
import org.eclipse.persistence.tools.gen.db.ForeignKey;
import org.eclipse.persistence.tools.gen.db.Schema;
import org.eclipse.persistence.tools.gen.db.Table;
import org.eclipse.persistence.tools.gen.internal.util.ForeignKeyInfo;

public class DBUtil {
    public static boolean isAutoIncrement(Column c) {
        return false;
    }

    public static List<ForeignKeyInfo> getForeignKeys(Table dbTable) {
        ArrayList<ForeignKeyInfo> ret = new ArrayList<ForeignKeyInfo>();
        if (dbTable != null) {
            for (ForeignKey fk : dbTable.getForeignKeys()) {
                Iterator<ForeignKey.ColumnPair> columnPaires = fk.getColumnPairs().iterator();
                ForeignKeyInfo fkInfo = null;
                while (columnPaires.hasNext()) {
                    ForeignKey.ColumnPair columnPair = columnPaires.next();
                    if (fkInfo == null) {
                        String tableName = dbTable.getName();
                        String referencedTableName = "";
                        Table referencedTable = fk.getReferencedTable();
                        referencedTableName = referencedTable.getName();
                        fkInfo = new ForeignKeyInfo(fk, tableName, referencedTableName);
                    }
                    String baseColName = columnPair.getBaseColumn().getName();
                    String referencedColName = columnPair.getReferencedColumn().getName();
                    fkInfo.addColumnMapping(baseColName, referencedColName);
                }
                if (fkInfo == null) continue;
                ret.add(fkInfo);
            }
        }
        return ret;
    }

    public static String getJavaType(Column dbColumn) {
        return dbColumn.isPartOfPrimaryKey() ? dbColumn.getPrimaryKeyJavaTypeDeclaration() : dbColumn.getJavaTypeDeclaration();
    }

    public static boolean isDefaultSchema(Table dbTable) {
        String schemaName = dbTable.getSchema().getName();
        Schema defaultSchema = dbTable.getSchema().getDatabase().getDefaultSchema();
        return defaultSchema.getName() == schemaName;
    }
}

