/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.persistence.tools.utility.ClassTools;
import org.eclipse.persistence.tools.utility.StringBuilderTools;
import org.eclipse.persistence.tools.utility.StringTools;

public final class ObjectTools {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean equals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object2 != null && object1.equals(object2);
    }

    public static boolean notEquals(Object object1, Object object2) {
        return !ObjectTools.equals(object1, object2);
    }

    public static int hashCode(Object object) {
        return ObjectTools.hashCode(object, 0);
    }

    public static int hashCode(Object object, int nullHashCode) {
        return object == null ? nullHashCode : object.hashCode();
    }

    public static String toString(Object object, Object additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, boolean additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, char additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, char[] additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, CharSequence additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, double additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, float additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, int additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, long additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, String additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object, StringBuffer additionalInfo) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        sb.append('(');
        sb.append(additionalInfo);
        sb.append(')');
        return sb.toString();
    }

    public static String toString(Object object) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendHashCodeToString(sb, object);
        return sb.toString();
    }

    public static String singletonToString(Object object) {
        return ClassTools.toStringName(object.getClass());
    }

    public static <T> T get(Object object, String fieldName) {
        try {
            return ObjectTools.get_(object, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + StringTools.CR + ObjectTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + StringTools.CR + ObjectTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
    }

    public static <T> T get_(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        return (T)ObjectTools.field_(object, fieldName).get(object);
    }

    public static void set(Object object, String fieldName, Object value) {
        try {
            ObjectTools.set_(object, fieldName, value);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + StringTools.CR + ObjectTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + StringTools.CR + ObjectTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
    }

    public static void set_(Object object, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        ObjectTools.field_(object, fieldName).set(object, value);
    }

    public static Field field(Object object, String fieldName) {
        try {
            return ObjectTools.field_(object, fieldName);
        }
        catch (NoSuchFieldException ex) {
            throw new RuntimeException(ex + StringTools.CR + ObjectTools.buildFullyQualifiedFieldName(object, fieldName), ex);
        }
    }

    public static Field field_(Object object, String fieldName) throws NoSuchFieldException {
        return ClassTools.field_(object.getClass(), fieldName);
    }

    private static String buildFullyQualifiedFieldName(Object object, String fieldName) {
        return ClassTools.buildFullyQualifiedFieldName(object.getClass(), fieldName);
    }

    public static <T> T execute(Object object, String methodName) {
        return ObjectTools.execute(object, methodName, ClassTools.EMPTY_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static Object execute_(Object object, String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ObjectTools.execute_(object, methodName, ClassTools.EMPTY_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    public static Object execute(Object object, String methodName, Class<?> parameterType, Object argument) {
        return ObjectTools.execute(object, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> T execute_(Object object, String methodName, Class<?> parameterType, Object argument) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return ObjectTools.execute_(object, methodName, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <T> T execute(Object object, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        return ObjectTools.execute(object, ObjectTools.method(object, methodName, parameterTypes), arguments);
    }

    public static <T> T execute(Object receiver, Method method, Object[] arguments) {
        try {
            return (T)method.invoke(receiver, arguments);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex + StringTools.CR + method, ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(method + StringTools.CR + ex.getTargetException(), ex);
        }
    }

    public static <T> T execute_(Object object, String methodName, Class<?>[] parameterTypes, Object[] arguments) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (T)ObjectTools.method_(object, methodName, parameterTypes).invoke(object, arguments);
    }

    public static Method method(Object object, String methodName) {
        return ClassTools.method(object.getClass(), methodName);
    }

    public static Method method_(Object object, String methodName) throws NoSuchMethodException {
        return ClassTools.method_(object.getClass(), methodName);
    }

    public static Method method(Object object, String methodName, Class<?> parameterType) {
        return ClassTools.method(object.getClass(), methodName, parameterType);
    }

    public static Method method_(Object object, String methodName, Class<?> parameterType) throws NoSuchMethodException {
        return ClassTools.method_(object.getClass(), methodName, parameterType);
    }

    public static Method method(Object object, String methodName, Class<?>[] parameterTypes) {
        return ClassTools.method(object.getClass(), methodName, parameterTypes);
    }

    public static Method method_(Object object, String methodName, Class<?>[] parameterTypes) throws NoSuchMethodException {
        return ClassTools.method_(object.getClass(), methodName, parameterTypes);
    }

    private ObjectTools() {
        throw new UnsupportedOperationException();
    }
}

