/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.command;

import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.CommandExecutor;

public abstract class AbstractThreadLocalCommandExecutor<E extends CommandExecutor>
implements CommandExecutor {
    protected final ThreadLocal<E> threadLocal;
    protected final E defaultCommandExecutor;

    protected AbstractThreadLocalCommandExecutor(E defaultCommandExecutor) {
        if (defaultCommandExecutor == null) {
            throw new NullPointerException();
        }
        this.defaultCommandExecutor = defaultCommandExecutor;
        this.threadLocal = this.buildThreadLocal();
    }

    protected ThreadLocal<E> buildThreadLocal() {
        return new ThreadLocal();
    }

    @Override
    public void execute(Command command) {
        this.getThreadLocalCommandExecutor().execute(command);
    }

    protected E getThreadLocalCommandExecutor() {
        CommandExecutor ce = (CommandExecutor)this.threadLocal.get();
        return (E)(ce != null ? ce : this.defaultCommandExecutor);
    }

    public void set(E commandExecutor) {
        this.threadLocal.set(commandExecutor);
    }

    public String toString() {
        return String.valueOf('[') + this.getThreadLocalCommandExecutor().toString() + ']';
    }
}

