/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.InheritanceType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntityTable;
import org.eclipse.persistence.tools.mapping.orm.ExternalORMConfiguration;
import org.eclipse.persistence.tools.mapping.orm.ExternalPrimaryKeyJoinColumn;
import org.eclipse.persistence.tools.mapping.orm.ExternalSecondaryTable;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.MappedSuperclassTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ORMConfigurationTests;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.collection.ListTools;
import org.w3c.dom.Node;

public final class EntityTests
extends MappedSuperclassTests<ExternalEntity> {
    private String buildCascadeOnDeleteTester() {
        return "cascade-on-delete";
    }

    private AbstractExternalFormTests.ExternalFormBuilder<ExternalEntity> buildEntityBuilder() {
        return new AbstractExternalFormTests.ExternalFormBuilder<ExternalEntity>(){

            @Override
            public ExternalEntity buildExternalForm() throws IOException {
                ORMConfiguration orm = ORMConfigurationTests.buildExternalForm();
                return orm.addEntity(EntityTests.this.defaultClassName());
            }

            @Override
            public ExternalEntity buildExternalForm(ExternalForm parentForm) {
                return ((ExternalORMConfiguration)parentForm).addEntity(EntityTests.this.defaultClassName());
            }

            @Override
            public int getDefaultAttributeCount() {
                return 1;
            }

            @Override
            public Node getNode(ExternalEntity form) {
                return (Node)ObjectTools.execute((Object)form, (String)"getElement");
            }

            @Override
            public String getNodeName() {
                return "entity";
            }

            @Override
            public List<String> getTreeNodeNames() {
                return ListTools.list((Object[])new String[]{"entity-mappings", "entity"});
            }
        };
    }

    private String buildIndexTester() {
        return "index";
    }

    private AbstractExternalFormTests.ChildAttributeTester<ExternalEntity, InheritanceType> buildInheritanceTester() {
        return new AbstractExternalFormTests.ChildAttributeTester<ExternalEntity, InheritanceType>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getChildNodeName() {
                return "inheritance";
            }

            @Override
            public InheritanceType getDefaultValue() {
                return InheritanceType.JOINED;
            }

            @Override
            public String getNodeName() {
                return "strategy";
            }

            @Override
            public InheritanceType getValue(ExternalEntity form) {
                return form.getInheritenceStrategy();
            }

            @Override
            public InheritanceType getValue1() {
                return InheritanceType.SINGLE_TABLE;
            }

            @Override
            public InheritanceType getValue2() {
                return InheritanceType.TABLE_PER_CLASS;
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalEntity form, InheritanceType value) {
                form.setInheritanceStrategy(value);
            }

            @Override
            public String toString(InheritanceType value) {
                return value.name();
            }
        };
    }

    private AbstractExternalFormTests.AttributeNodeTester<ExternalEntity, String> buildNameTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<ExternalEntity, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return "default_name";
            }

            @Override
            public String getNodeName() {
                return "name";
            }

            @Override
            public String getValue(ExternalEntity form) {
                return form.getName();
            }

            @Override
            public String getValue1() {
                return "employee";
            }

            @Override
            public String getValue2() {
                return "address";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(ExternalEntity form, String value) {
                form.setName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private String buildPrimaryKeyForeignKeyTester() {
        return "primary-key-foreign-key";
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalEntity, ExternalPrimaryKeyJoinColumn, String> buildPrimaryKeyJoinColumnTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalEntity, ExternalPrimaryKeyJoinColumn, String>(){

            @Override
            public ExternalPrimaryKeyJoinColumn addChild(ExternalEntity form, String value) {
                return form.addPrimaryKeyJoinColumn(value);
            }

            @Override
            public ExternalPrimaryKeyJoinColumn getChild(ExternalEntity form, int index) {
                return form.getPrimaryKeyJoinColumn(index);
            }

            @Override
            public ExternalPrimaryKeyJoinColumn getChildForm(List<ExternalPrimaryKeyJoinColumn> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalPrimaryKeyJoinColumn> getChildren(ExternalEntity form) {
                return form.primaryKeyJoinColumns();
            }

            @Override
            public int getChildrenSize(ExternalEntity form) {
                return form.primaryKeyJoinColumnsSize();
            }

            @Override
            public String getChildValue(ExternalPrimaryKeyJoinColumn childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "PRIMARY_KEY_JOIN_COLUMN_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "primary-key-join-column";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalEntity form, int index) {
                form.removePrimaryKeyJoinColumn(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildListNodeTester<ExternalEntity, ExternalSecondaryTable, String> buildSecondaryTableTester() {
        return new AbstractExternalFormTests.ChildListNodeTester<ExternalEntity, ExternalSecondaryTable, String>(){

            @Override
            public ExternalSecondaryTable addChild(ExternalEntity form, String value) {
                return form.addSecondaryTable(value, null, null);
            }

            @Override
            public ExternalSecondaryTable getChild(ExternalEntity form, int index) {
                return form.getSecondaryTable(index);
            }

            @Override
            public ExternalSecondaryTable getChildForm(List<ExternalSecondaryTable> childForms, int index) {
                return childForms.get(index);
            }

            @Override
            public List<ExternalSecondaryTable> getChildren(ExternalEntity form) {
                return form.secondaryTables();
            }

            @Override
            public int getChildrenSize(ExternalEntity form) {
                return form.secondaryTablesSize();
            }

            @Override
            public String getChildValue(ExternalSecondaryTable childForm) {
                return childForm.getName();
            }

            @Override
            public String getExpectedChildValue(int index) {
                return "SECONDARY_TABLE_" + index;
            }

            @Override
            public List<String> getExpectedChildValues() {
                ArrayList<String> values = new ArrayList<String>();
                int index = 0;
                while (index < 10) {
                    values.add(this.getExpectedChildValue(index));
                    ++index;
                }
                return values;
            }

            @Override
            public String getNodeName() {
                return "secondary-table";
            }

            @Override
            public List<String> getNodeNames() {
                return Collections.singletonList(this.getNodeName());
            }

            @Override
            public void removeChild(ExternalEntity form, int index) {
                form.removeSecondaryTable(index);
            }
        };
    }

    private AbstractExternalFormTests.ChildNodeTester<ExternalEntity, ExternalEntityTable> buildTableTester() {
        return new AbstractExternalFormTests.ChildNodeTester<ExternalEntity, ExternalEntityTable>(){

            @Override
            public ExternalEntityTable addChild(ExternalEntity form) {
                return form.addPrimaryTable(null);
            }

            @Override
            public ExternalEntityTable getChild(ExternalEntity form) {
                return form.getPrimaryTable();
            }

            @Override
            public String getNodeName() {
                return "table";
            }

            @Override
            public boolean hasChild(ExternalEntity form) {
                return form.hasPrimaryTable();
            }

            @Override
            public void removeChild(ExternalEntity form) {
                form.removePrimaryTable();
            }
        };
    }

    @Override
    String defaultClassName() {
        return "org.eclipse.persistence.tool.mappings.tests.Entity";
    }

    @Override
    protected void populate(AbstractExternalFormTests.RootNodeTester tester) {
        tester.setBuilder(this.buildEntityBuilder());
        tester.addAttribute(this.buildNameTester());
        tester.addAttribute(this.buildClassTester());
        tester.addAttribute(this.buildParentClassTester());
        tester.addAttribute(this.buildAccessTester());
        tester.addAttribute(this.buildCacheableTester());
        tester.addAttribute(this.buildMetadataCompleteTester());
        tester.addAttribute(this.buildReadOnlyTester());
        tester.addAttribute(this.buildExistenceCheckingTester());
        tester.addAttribute(this.buildExcludeDefaultMappingsTester());
        tester.addTextNode(this.buildDescriptionTester());
        tester.addNode(this.buildAccessMethodsTester());
        tester.addNode(this.buildMultitenantTester());
        tester.addUnsupportedNode(this.buildAdditionalCriteriaTester());
        tester.addChildAttribute(this.buildCustomizerTester());
        tester.addChildAttribute(this.buildChangeTrackingTester());
        tester.addNode(this.buildTableTester());
        tester.addListNodes(this.buildSecondaryTableTester());
        tester.addUnsupportedNode(this.buildStructTester());
        tester.addListNodes(this.buildPrimaryKeyJoinColumnTester());
        tester.addUnsupportedNode(this.buildPrimaryKeyForeignKeyTester());
        tester.addNode(this.buildNoSqlTester());
        tester.addUnsupportedNode(this.buildCascadeOnDeleteTester());
        tester.addUnsupportedNode(this.buildIndexTester());
        tester.addChildAttribute(this.buildIdClassTester());
        tester.addNode(this.buildPrimaryKeyTester());
        tester.addChildAttribute(this.buildInheritanceTester());
        tester.addNode(this.buildOptimisticLockingTester());
        tester.addNode(this.buildCacheTester());
        tester.addChildAttribute(this.buildCacheInterceptorTester());
        tester.addUnsupportedNode(this.buildCacheIndexTester());
        tester.addListNodes(this.buildFetchGroupTester());
        tester.addListNodes(this.buildConverterTester());
        tester.addListNodes(this.buildTypeConverterTester());
        tester.addListNodes(this.buildObjectTypeConverterTester());
        tester.addUnsupportedNode(this.buildSerializedConverterTester());
        tester.addListNodes(this.buildStructConverterTester());
        tester.addNode(this.buildCopyPolicyTester());
        tester.addNode(this.buildInstantiationCopyPolicyTester());
        tester.addNode(this.buildCloneCopyPolicyTester());
        tester.addUnsupportedNode(this.buildSerializedObjectTester());
        tester.addNode(this.buildSequenceGeneratorTester());
        tester.addNode(this.buildTableGeneratorTester());
        tester.addUnsupportedNode(this.buildUuidGeneratorTester());
        tester.addUnsupportedNode(this.buildPartitioningTester());
        tester.addUnsupportedNode(this.buildReplicationPartitioningTester());
        tester.addUnsupportedNode(this.buildRoundRobinPartitioningTester());
        tester.addUnsupportedNode(this.buildPinnedPartitioningTester());
        tester.addUnsupportedNode(this.buildRangePartitioningTester());
        tester.addUnsupportedNode(this.buildValuePartitioningTester());
        tester.addUnsupportedNode(this.buildHashPartitioningTester());
        tester.addUnsupportedNode(this.buildUnionPartitioningTester());
        tester.addUnsupportedNode(this.buildPartitionedTester());
        tester.addListNodes(this.buildNamedQueryTester());
        tester.addListNodes(this.buildNamedNativeQueryTester());
        tester.addListNodes(this.buildNamedStoredProcedureQueryTester());
        tester.addUnsupportedNode(this.buildNamedStoredFunctionQueryTester());
        tester.addUnsupportedNode(this.buildNamedPlsqlStoredProcedureQueryTester());
        tester.addUnsupportedNode(this.buildNamedPlsqlStoredFunctionQueryTester());
        tester.addUnsupportedNode(this.buildOracleObjectTester());
        tester.addUnsupportedNode(this.buildOracleArrayTester());
        tester.addUnsupportedNode(this.buildPlsqlRecordTester());
        tester.addUnsupportedNode(this.buildPlsqlTableTester());
        tester.addUnsupportedNode(this.buildSqlResultSetMappingTester());
        tester.addUnsupportedNode(this.buildQueryRedirectorsTester());
        tester.addBooleanNode(this.buildExcludeDefaultListenersTester());
        tester.addBooleanNode(this.buildExcludeSuperclassListenersTester());
        tester.addContainerListNodes(this.buildEntityListenersTester());
        tester.addChildAttribute(this.buildPrePersistClassTester());
        tester.addChildAttribute(this.buildPostPersistClassTester());
        tester.addChildAttribute(this.buildPreRemoveClassTester());
        tester.addChildAttribute(this.buildPostRemoveClassTester());
        tester.addChildAttribute(this.buildPreUpdateClassTester());
        tester.addChildAttribute(this.buildPostUpdateClassTester());
        tester.addChildAttribute(this.buildPostLoadClassTester());
        tester.addListNodes(this.buildPropertyTester());
        tester.addListNodes(this.buildAttributeOverrideTester());
        tester.addListNodes(this.buildAssociationOverrideTester());
        tester.addContainerListNodes(this.buildAttributesTester());
    }
}

