/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.tests.dom.orm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.mapping.orm.ExternalEntity;
import org.eclipse.persistence.tools.mapping.orm.ExternalMapping;
import org.eclipse.persistence.tools.mapping.orm.dom.ORMConfiguration;
import org.eclipse.persistence.tools.mapping.tests.AbstractExternalFormTests;
import org.eclipse.persistence.tools.mapping.tests.dom.orm.ORMConfigurationTests;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.junit.After;
import org.w3c.dom.Node;

public abstract class MappingTests<T extends ExternalMapping>
extends AbstractExternalFormTests<T> {
    private String mappingName;

    abstract void addAttributeTesters(AbstractExternalFormTests.RootNodeTester var1);

    abstract void addChildTesters(AbstractExternalFormTests.RootNodeTester var1);

    abstract T addMapping(ExternalEntity var1);

    final AbstractExternalFormTests.AttributeNodeTester<T, String> buildAttributeTypeTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return false;
            }

            @Override
            public String getDefaultValue() {
                return String.valueOf(MappingTests.this.mappingName()) + "_type_default";
            }

            @Override
            public String getNodeName() {
                return "attribute-type";
            }

            @Override
            public String getValue(T form) {
                return form.getAttributeType();
            }

            @Override
            public String getValue1() {
                return String.valueOf(MappingTests.this.mappingName()) + "_type_one";
            }

            @Override
            public String getValue2() {
                return String.valueOf(MappingTests.this.mappingName()) + "_type_two";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return true;
            }

            @Override
            public boolean isNullAllowed() {
                return true;
            }

            @Override
            public void setValue(T form, String value) {
                form.setAttributeType(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    private AbstractExternalFormTests.ExternalFormBuilder<T> buildMappingBuilder() {
        return new AbstractExternalFormTests.ExternalFormBuilder<T>(){

            @Override
            public T buildExternalForm() throws IOException {
                ORMConfiguration orm = ORMConfigurationTests.buildExternalForm();
                ExternalEntity entity = orm.addEntity(MappingTests.this.entityClassName());
                return MappingTests.this.addMapping(entity);
            }

            @Override
            public T buildExternalForm(ExternalForm parentForm) {
                return MappingTests.this.addMapping((ExternalEntity)parentForm);
            }

            @Override
            public int getDefaultAttributeCount() {
                return 1;
            }

            @Override
            public Node getNode(T form) {
                return (Node)ObjectTools.execute(form, (String)"getElement");
            }

            @Override
            public String getNodeName() {
                return MappingTests.this.elementName();
            }

            @Override
            public List<String> getTreeNodeNames() {
                ArrayList<String> names = new ArrayList<String>();
                names.add("entity-mappings");
                names.add("entity");
                names.add("attributes");
                names.add(MappingTests.this.elementName());
                return names;
            }
        };
    }

    final AbstractExternalFormTests.AttributeNodeTester<T, String> buildNameTester() {
        return new AbstractExternalFormTests.AttributeNodeTester<T, String>(){

            @Override
            public boolean doesNodeAlreadyExist() {
                return true;
            }

            @Override
            public String getDefaultValue() {
                return MappingTests.this.mappingName();
            }

            @Override
            public String getNodeName() {
                return "name";
            }

            @Override
            public String getValue(T form) {
                return form.getName();
            }

            @Override
            public String getValue1() {
                return String.valueOf(MappingTests.this.mappingName()) + "_one";
            }

            @Override
            public String getValue2() {
                return String.valueOf(MappingTests.this.mappingName()) + "_two";
            }

            @Override
            public boolean isNodeDeletedWithNullValue() {
                return false;
            }

            @Override
            public boolean isNullAllowed() {
                return false;
            }

            @Override
            public void setValue(T form, String value) {
                form.setName(value);
            }

            @Override
            public String toString(String value) {
                return value;
            }
        };
    }

    abstract String elementName();

    private String entityClassName() {
        return "org.eclipse.persistence.tool.mappings.tests.Entity";
    }

    final String mappingName() {
        if (this.mappingName == null) {
            return "mapping_name_" + new Random().nextInt();
        }
        return this.mappingName;
    }

    @Override
    protected final void populate(AbstractExternalFormTests.RootNodeTester tester) {
        tester.setBuilder(this.buildMappingBuilder());
        this.addAttributeTesters(tester);
        this.addChildTesters(tester);
    }

    @After
    public void tearDown() {
        this.mappingName = null;
    }
}

