/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.annotations.CacheCoordinationType;
import org.eclipse.persistence.annotations.CacheType;
import org.eclipse.persistence.annotations.DatabaseChangeNotificationType;
import org.eclipse.persistence.config.CacheIsolationType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for an
 * optimistic locking definition in the EclipseLink 1.1 ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see org.eclipse.persistence.annotations.Cache
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalCache extends ExternalForm {

	/**
	 * The attribute name used to store and retrieve the always-refresh property.
	 */
	String ALWAYS_REFRESH = "always-refresh";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String CACHE = "cache";

	/**
	 * The attribute name used to store and retrieve the coordination-type property.
	 */
	String COORDINATION_TYPE = "coordination-type";

	/**
	 * The attribute name used to store and retrieve the database-change-notification-type property.
	 */
	String DATABASE_CHANGE_NOTIFICATION_TYPE = "database-change-notification-type";

	/**
	 * The attribute name used to store and retrieve the disable-hits property.
	 */
	String DISABLE_HITS = "disable-hits";

	/**
	 * The element name used to store and retrieve the expiry child text node.
	 */
	String EXPIRY = "expiry";

	/**
	 * The attribute name used to store and retrieve the isolation property.
	 */
	String ISOLATION = "isolation";

	/**
	 * The attribute name used to store and retrieve the refresh-only-if-newer property.
	 */
	String REFRESH_ONLY_IF_NEWER = "refresh-only-if-newer";

	/**
	 * The attribute name used to store and retrieve the shared property.
	 */
	String SHARED = "shared";

	/**
	 * The attribute name used to store and retrieve the size property.
	 */
	String SIZE = "size";

	/**
	 * The attribute name used to store and retrieve the type property.
	 */
	String TYPE = "type";

	/**
	 * Adds the time of day for expiration for this cache.
	 */
	ExternalTimeOfDay addExpiryTimeOfDay();

	/**
	 * Returns the {@link TextRange} for the always refreshed value.
	 */
	TextRange getAlwaysRefreshTextRange();

	/**
	 * Returns the coordination type for this cache.
	 */
	CacheCoordinationType getCoordinationType();

	/**
	 * Returns the {@link TextRange} for the coordination type for this cache.
	 */
	TextRange getCoordinationTypeTextRange();

	/**
	 * Returns the database change notification type for this cache.
	 */
	DatabaseChangeNotificationType getDatabaseChangeNotificationType();

	/**
	 * Returns the {@link TextRange} for the database change notification type for this cache.
	 */
	TextRange getDatabaseChangeNotificationTypeTextRange();

	/**
	 * Returns the {@link TextRange} for the cache disables hits value.
	 */
	TextRange getDisableHitsTextRange();

	/**
	 * Returns this cache's time of day for expiration.
	 */
	ExternalTimeOfDay getExpiryTimeOfDay();

	/**
	 * Returns the {@link TextRange} for the time of day for expiration.
	 */
	TextRange getExpiryTimeOfDayTextRange();

	/**
	 * Returns this cache's time to live before expiration.
	 */
	Integer getExpiryTimeToLive();

	/**
	 * Returns the {@link TextRange} for the cache's time to live before expiration.
	 */
	TextRange getExpiryTimeToLiveTextRange();

	/**
	 * Returns the isolation type for this cache
	 */
	CacheIsolationType getIsolationType();

	/**
	 * Returns the isolation type's {@link TextRange} for this cache
	 */
	TextRange getIsolationTypeTextRange();

	/**
	 * Returns the {@link TextRange} for the cache refreshes only if newer value.
	 */
	TextRange getRefreshOnlyIfNewerTextRange();

	/**
	 * Returns the {@link TextRange} for the cache is shared value.
	 */
	TextRange getSharedTextRange();

	/**
	 * Returns the size of the cache.
	 */
	Integer getSize();

	/**
	 * Returns the {@link TextRange} size of the cache.
	 */
	TextRange getSizeTextRange();

	/**
	 * Returns the type of this cache.
	 */
	CacheType getType();

	/**
	 * Returns the {@link TextRange} for the type of this cache.
	 */
	TextRange getTypeTextRange();

	/**
	 * Determines whether this cache's time of day for expiration is defined or not.
	 */
	boolean hasExpiryTimeOfDay();

	/**
	 * Returns whether this cache is always refreshed.
	 */
	Boolean isAlwaysRefresh();

	/**
	 * Returns whether this cache disables hits.
	 */
	Boolean isDisableHits();

	/**
	 * Returns whether this cache refreshes only if newer.
	 */
	Boolean isRefreshOnlyIfNewer();

	/**
	 * Returns whether this cache is shared.
	 */
	Boolean isShared();

	/**
	 * Removes the time of day for expiration for this cache.
	 */
	void removeExpiryTimeOfDay();

	/**
	 * Sets whether this cache always refreshes.
	 */
	void setAlwaysRefresh(Boolean alwaysRefresh);

	/**
	 * Sets the coordination type for this cache.
	 */
	void setCoordinationType(CacheCoordinationType type);

	/**
	 * Sets the database change notification type for this cache.
	 */
	void setDatabaseChangeNotificationType(DatabaseChangeNotificationType type);

	/**
	 * Sets whether this cache disables hits.
	 */
	void setDisableHits(Boolean disableHits);

	/**
	 * Sets the time to live for this cache.
	 */
	void setExpiryTimeToLive(Integer timeToLive);

	/**
	 * Sets the isolation type for this cache.
	 */
	void setIsolationType(CacheIsolationType isolationType);

	/**
	 * Sets whether this cache refreshes only if newer.
	 */
	void setRefreshOnlyIfNewer(Boolean refreshOnlyIfNewer);

	/**
	 * Sets whether this cache is shared.
	 */
	void setShared(Boolean shared);

	/**
	 * Sets the size for this cache.
	 */
	void setSize(Integer size);

	/**
	 * Sets the type for this cache.
	 */
	void setType(CacheType type);
}