/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface represents the basis for all convertible mapping types defined by the EclipseLink
 * JPA spec that are available for configuration via the EclipseLink ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalConvertibleMapping extends ExternalNonTransientMapping {

	/**
	 * The element name used to store and retrieve the convert child text node.
	 */
	String CONVERT = "convert";

	/**
	 * Sets the mapping to use this converter for its value converter.
	 */
	ExternalClassConverter addConverter();

	/**
	 * Sets the mapping to use this object type converter for its value converter.
	 */
	ExternalObjectTypeConverter addObjectTypeConverter();

	/**
	 * Sets the mapping to use this struct converter for its value converter.
	 */
	ExternalStructConverter addStructConverter();

	/**
	 * Sets the mapping to use this type converter for its value converter.
	 */
	ExternalTypeConverter addTypeConverter();

	/**
	 * Returns the converter string for this mapping.
	 */
	String getConvert();

	/**
	 * Returns the value converter for this mapping.
	 */
	ExternalClassConverter getConverter();

	/**
	 * Returns the {@link TextRange} for the converter string for this mapping.
	 */
	TextRange getConvertTextRange();

	/**
	 * Returns the value object type converter for this mapping.
	 */
	ExternalObjectTypeConverter getObjectTypeConverter();

	/**
	 * Returns the value struct converter for this mapping.
	 */
	ExternalStructConverter getStructConverter();

	/**
	 * Returns the value type converter for this mapping.
	 */
	ExternalTypeConverter getTypeConverter();

	/**
	 * Removes the value converter from mapping.
	 */
	void removeConverter();

	/**
	 * Removes the value object type converter from mapping.
	 */
	void removeObjectTypeConverter();

	/**
	 * Removes the value struct converter from mapping.
	 */
	void removeStructConverter();

	/**
	 * Removes the value type converter from mapping.
	 */
	void removeTypeConverter();

	/**
	 * Sets the value converter string.
	 */
	void setConvert(String value);
}