/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import javax.persistence.GenerationType;
import org.eclipse.persistence.tools.mapping.ExternalForm;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and describes the configurable properties defined for a generated value declared
 * on an ID field of an entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.GeneratedValue
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalEntityIDGeneratedValue extends ExternalForm {

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String GENERATED_VALUE = "generated-value";

	/**
	 * The attribute name used to store and retrieve the generator property.
	 */
	String GENERATOR = "generator";

	/**
	 * The attribute name used to store and retrieve the strategy property.
	 */
	String STRATEGY = "strategy";

	/**
	 * Returns the generation type for this value.
	 */
	GenerationType getGenerationType();

	/**
	 * Returns the {@link TextRange} for the generation type for this value.
	 */
	TextRange getGenerationTypeTextRange();

	/**
	 * Returns the name of the id generator specified for this id's value.
	 */
	String getGeneratorName();

	/**
	 * Returns the {@link TextRange} for the name of the id generator specified for this id's value.
	 */
	TextRange getGeneratorNameTextRange();

	/**
	 * Set the generation type for this value.
	 */
	void setGenerationType(GenerationType type);

	/**
	 * Sets the name of the id generator to use for this id's value.
	 */
	void setGeneratorName(String generatorName);
}