/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.mapping.ExternalForm;

/**
 * Defines an external ORM object that holds on to {@link ExternalEntityListener}. Implementors of
 * this interface know how to retrieve, remove, and create an entity listener.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @version 2.6
 */
public interface ExternalEntityListenerHolder extends ExternalForm {

	/**
	 * Adds a entity listener with the given name.
	 */
	ExternalEntityListener addEntityListener(String className);

	/**
	 * Returns a list of entity listeners to be used in this external form.
	 */
	List<ExternalEntityListener> entityListeners();

	/**
	 * Returns the count of entity listeners.
	 */
	int entityListenersSize();

	/**
	 * Retrieves an entity listener for the given class name if it exists.
	 */
	ExternalEntityListener getEntityListener(int index);

	/**
	 * Removes the entity listener at the given position.
	 */
	void removeEntityListener(int index);
}