/*******************************************************************************
 * Copyright (c) 2006, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

import java.util.List;
import org.eclipse.persistence.tools.utility.TextRange;

/**
 * This interface and inherited behavior describe the configurable properties defined for a
 * many-to-one in the ORM xml.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.ManyToOne
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.6
 */
@SuppressWarnings("nls")
public interface ExternalManyToOneMapping extends ExternalMappableMapping,
                                                  ExternaNoSqlJoinFieldMapping {

	/**
	 * The attribute name used to store and retrieve the id property.
	 */
	String ID = "id";

	/**
	 * The node name used to store and retrieve the element encapsulated by this external form.
	 */
	String MANY_TO_ONE = "many-to-one";

	/**
	 * The attribute name used to store and retrieve the maps-id property.
	 */
	String MAPS_ID = "maps-id";

	/**
	 * Visits this {@link ExternalManyToOneMapping} by the given {@link ExternalMappingVisitor visitor}.
	 *
	 * @param visitor The {@link ExternalMappingVisitor} to visit this object
	 */
	void accept(ExternalMappingVisitor visitor);

	/**
	 * Adds a join column with the given name
	 */
	ExternalJoinColumn addJoinColumn(String name);

	/**
	 * Returns the id property.
	 */
	Boolean getId();

	/**
	 * Returns the {@link TextRange} for the id property.
	 */
	TextRange getIdTextRange();

	/**
	 * Returns a join column with the given name.
	 */
	ExternalJoinColumn getJoinColumn(int index);

	/**
	 * Returns maps id.
	 */
	String getMapsId();

	/**
	 * Returns the {@link TextRange} for the maps id value.
	 */
	TextRange getMapsIdTextRange();

	/**
	 * Returns the join column for this mapping.
	 */
	List<ExternalJoinColumn> joinColumns();

	/**
	 * Returns the count of join columns for this mapping.
	 */
	int joinColumnsSize();

	/**
	 * Removes the join column named.
	 */
	void removeJoinColumn(int index);

	/**
	 * Sets id.
	 */
	void setId(Boolean id);

	/**
	 * Sets maps id.
	 */
	void setMapsId(String mapsId);
}